/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute.internal.expression;

import com.speedment.common.function.BooleanToDoubleFunction;
import com.speedment.common.function.BooleanUnaryOperator;
import com.speedment.common.function.ByteToDoubleFunction;
import com.speedment.common.function.ByteUnaryOperator;
import com.speedment.common.function.CharUnaryOperator;
import com.speedment.common.function.FloatToDoubleFunction;
import com.speedment.common.function.FloatUnaryOperator;
import com.speedment.common.function.ShortToDoubleFunction;
import com.speedment.common.function.ShortUnaryOperator;
import com.speedment.runtime.compute.ToBigDecimal;
import com.speedment.runtime.compute.ToBoolean;
import com.speedment.runtime.compute.ToByte;
import com.speedment.runtime.compute.ToChar;
import com.speedment.runtime.compute.ToDouble;
import com.speedment.runtime.compute.ToEnum;
import com.speedment.runtime.compute.ToFloat;
import com.speedment.runtime.compute.ToInt;
import com.speedment.runtime.compute.ToLong;
import com.speedment.runtime.compute.ToShort;
import com.speedment.runtime.compute.ToString;
import com.speedment.runtime.compute.expression.Expression;
import com.speedment.runtime.compute.expression.MapperExpression;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.ToDoubleFunction;
import java.util.function.UnaryOperator;

public final class MapperUtil {
    public static <T> ToBoolean<T> mapBoolean(ToBoolean<T> expression, BooleanUnaryOperator mapper) {
        return new ToBooleanMapper<T, ToBoolean<T>, BooleanUnaryOperator>(expression, mapper){

            @Override
            public boolean applyAsBoolean(T object) {
                return ((BooleanUnaryOperator)this.mapper).applyAsBoolean(((ToBoolean)this.inner).applyAsBoolean(object));
            }

            @Override
            public MapperExpression.MapperType mapperType() {
                return MapperExpression.MapperType.BOOLEAN_TO_BOOLEAN;
            }
        };
    }

    public static <T> ToDouble<T> mapBooleanToDouble(ToBoolean<T> expression, BooleanToDoubleFunction mapper) {
        return new ToDoubleMapper<T, ToBoolean<T>, BooleanToDoubleFunction>(expression, mapper){

            @Override
            public double applyAsDouble(T object) {
                return ((BooleanToDoubleFunction)this.mapper).applyAsDouble(((ToBoolean)this.inner).applyAsBoolean(object));
            }

            @Override
            public MapperExpression.MapperType mapperType() {
                return MapperExpression.MapperType.BOOLEAN_TO_DOUBLE;
            }
        };
    }

    public static <T> ToChar<T> mapChar(ToChar<T> expression, CharUnaryOperator mapper) {
        return new ToCharMapper<T, ToChar<T>, CharUnaryOperator>(expression, mapper){

            public char applyAsChar(T object) {
                return ((CharUnaryOperator)this.mapper).applyAsChar(((ToChar)this.inner).applyAsChar(object));
            }

            @Override
            public MapperExpression.MapperType mapperType() {
                return MapperExpression.MapperType.CHAR_TO_CHAR;
            }
        };
    }

    public static <T> ToByte<T> mapByte(ToByte<T> expression, ByteUnaryOperator mapper) {
        return new ToByteMapper<T, ToByte<T>, ByteUnaryOperator>(expression, mapper){

            @Override
            public byte applyAsByte(T object) {
                return ((ByteUnaryOperator)this.mapper).applyAsByte(((ToByte)this.inner).applyAsByte(object));
            }

            @Override
            public MapperExpression.MapperType mapperType() {
                return MapperExpression.MapperType.BYTE_TO_BYTE;
            }
        };
    }

    public static <T> ToDouble<T> mapByteToDouble(ToByte<T> expression, ByteToDoubleFunction mapper) {
        return new ToDoubleMapper<T, ToByte<T>, ByteToDoubleFunction>(expression, mapper){

            @Override
            public double applyAsDouble(T object) {
                return ((ByteToDoubleFunction)this.mapper).applyAsDouble(((ToByte)this.inner).applyAsByte(object));
            }

            @Override
            public MapperExpression.MapperType mapperType() {
                return MapperExpression.MapperType.BYTE_TO_DOUBLE;
            }
        };
    }

    public static <T> ToShort<T> mapShort(ToShort<T> expression, ShortUnaryOperator mapper) {
        return new ToShortMapper<T, ToShort<T>, ShortUnaryOperator>(expression, mapper){

            @Override
            public short applyAsShort(T object) {
                return ((ShortUnaryOperator)this.mapper).applyAsShort(((ToShort)this.inner).applyAsShort(object));
            }

            @Override
            public MapperExpression.MapperType mapperType() {
                return MapperExpression.MapperType.SHORT_TO_SHORT;
            }
        };
    }

    public static <T> ToDouble<T> mapShortToDouble(ToShort<T> expression, ShortToDoubleFunction mapper) {
        return new ToDoubleMapper<T, ToShort<T>, ShortToDoubleFunction>(expression, mapper){

            @Override
            public double applyAsDouble(T object) {
                return ((ShortToDoubleFunction)this.mapper).applyAsDouble(((ToShort)this.inner).applyAsShort(object));
            }

            @Override
            public MapperExpression.MapperType mapperType() {
                return MapperExpression.MapperType.SHORT_TO_DOUBLE;
            }
        };
    }

    public static <T> ToInt<T> mapInt(ToInt<T> expression, IntUnaryOperator mapper) {
        return new ToIntMapper<T, ToInt<T>, IntUnaryOperator>(expression, mapper){

            @Override
            public int applyAsInt(T object) {
                return ((IntUnaryOperator)this.mapper).applyAsInt(((ToInt)this.inner).applyAsInt(object));
            }

            @Override
            public MapperExpression.MapperType mapperType() {
                return MapperExpression.MapperType.INT_TO_INT;
            }
        };
    }

    public static <T> ToDouble<T> mapIntToDouble(ToInt<T> expression, IntToDoubleFunction mapper) {
        return new ToDoubleMapper<T, ToInt<T>, IntToDoubleFunction>(expression, mapper){

            @Override
            public double applyAsDouble(T object) {
                return ((IntToDoubleFunction)this.mapper).applyAsDouble(((ToInt)this.inner).applyAsInt(object));
            }

            @Override
            public MapperExpression.MapperType mapperType() {
                return MapperExpression.MapperType.INT_TO_DOUBLE;
            }
        };
    }

    public static <T> ToLong<T> mapLong(ToLong<T> expression, LongUnaryOperator mapper) {
        return new ToLongMapper<T, ToLong<T>, LongUnaryOperator>(expression, mapper){

            @Override
            public long applyAsLong(T object) {
                return ((LongUnaryOperator)this.mapper).applyAsLong(((ToLong)this.inner).applyAsLong(object));
            }

            @Override
            public MapperExpression.MapperType mapperType() {
                return MapperExpression.MapperType.LONG_TO_LONG;
            }
        };
    }

    public static <T> ToDouble<T> mapLongToDouble(ToLong<T> expression, LongToDoubleFunction mapper) {
        return new ToDoubleMapper<T, ToLong<T>, LongToDoubleFunction>(expression, mapper){

            @Override
            public double applyAsDouble(T object) {
                return ((LongToDoubleFunction)this.mapper).applyAsDouble(((ToLong)this.inner).applyAsLong(object));
            }

            @Override
            public MapperExpression.MapperType mapperType() {
                return MapperExpression.MapperType.LONG_TO_DOUBLE;
            }
        };
    }

    public static <T> ToFloat<T> mapFloat(ToFloat<T> expression, FloatUnaryOperator mapper) {
        return new ToFloatMapper<T, ToFloat<T>, FloatUnaryOperator>(expression, mapper){

            @Override
            public float applyAsFloat(T object) {
                return ((FloatUnaryOperator)this.mapper).applyAsFloat(((ToFloat)this.inner).applyAsFloat(object));
            }

            @Override
            public MapperExpression.MapperType mapperType() {
                return MapperExpression.MapperType.FLOAT_TO_FLOAT;
            }
        };
    }

    public static <T> ToDouble<T> mapFloatToDouble(ToFloat<T> expression, FloatToDoubleFunction mapper) {
        return new ToDoubleMapper<T, ToFloat<T>, FloatToDoubleFunction>(expression, mapper){

            @Override
            public double applyAsDouble(T object) {
                return ((FloatToDoubleFunction)this.mapper).applyAsDouble(((ToFloat)this.inner).applyAsFloat(object));
            }

            @Override
            public MapperExpression.MapperType mapperType() {
                return MapperExpression.MapperType.FLOAT_TO_DOUBLE;
            }
        };
    }

    public static <T> ToDouble<T> mapDouble(ToDouble<T> expression, DoubleUnaryOperator mapper) {
        return new ToDoubleMapper<T, ToDouble<T>, DoubleUnaryOperator>(expression, mapper){

            @Override
            public double applyAsDouble(T object) {
                return ((DoubleUnaryOperator)this.mapper).applyAsDouble(((ToDouble)this.inner).applyAsDouble(object));
            }

            @Override
            public MapperExpression.MapperType mapperType() {
                return MapperExpression.MapperType.DOUBLE_TO_DOUBLE;
            }
        };
    }

    public static <T> ToString<T> mapString(ToString<T> expression, UnaryOperator<String> mapper) {
        return new ToStringMapper<T, ToString<T>, UnaryOperator<String>>(expression, mapper){

            @Override
            public String apply(T object) {
                return (String)((UnaryOperator)this.mapper).apply(((ToString)this.inner).apply(object));
            }

            @Override
            public MapperExpression.MapperType mapperType() {
                return MapperExpression.MapperType.STRING_TO_STRING;
            }
        };
    }

    public static <T, E extends Enum<E>> ToEnum<T, E> mapEnum(ToEnum<T, E> expression, UnaryOperator<E> mapper) {
        return new ToEnumMapper<T, E, ToEnum<T, E>, UnaryOperator<E>>(expression, mapper){

            @Override
            public E apply(T object) {
                return (Enum)((UnaryOperator)this.mapper).apply(((ToEnum)this.inner).apply(object));
            }

            @Override
            public Class<E> enumClass() {
                return ((ToEnum)this.inner).enumClass();
            }

            @Override
            public MapperExpression.MapperType mapperType() {
                return MapperExpression.MapperType.ENUM_TO_ENUM;
            }
        };
    }

    public static <T> ToBigDecimal<T> mapBigDecimal(ToBigDecimal<T> expression, UnaryOperator<BigDecimal> mapper) {
        return new ToBigDecimalMapper<T, ToBigDecimal<T>, UnaryOperator<BigDecimal>>(expression, mapper){

            @Override
            public BigDecimal apply(T object) {
                return (BigDecimal)((UnaryOperator)this.mapper).apply(((ToBigDecimal)this.inner).apply(object));
            }

            @Override
            public MapperExpression.MapperType mapperType() {
                return MapperExpression.MapperType.BIG_DECIMAL_TO_BIG_DECIMAL;
            }
        };
    }

    public static <T> ToDouble<T> mapBigDecimalToDouble(ToBigDecimal<T> expression, ToDoubleFunction<BigDecimal> mapper) {
        return new ToDoubleMapper<T, ToBigDecimal<T>, ToDoubleFunction<BigDecimal>>(expression, mapper){

            @Override
            public double applyAsDouble(T object) {
                return ((ToDoubleFunction)this.mapper).applyAsDouble(((ToBigDecimal)this.inner).apply(object));
            }

            @Override
            public MapperExpression.MapperType mapperType() {
                return MapperExpression.MapperType.BIG_DECIMAL_TO_DOUBLE;
            }
        };
    }

    private MapperUtil() {
    }

    private static abstract class AbstractMapper<T, INNER extends Expression<T>, MAPPER>
    implements MapperExpression<T, INNER, MAPPER> {
        final INNER inner;
        final MAPPER mapper;

        AbstractMapper(INNER inner, MAPPER mapper) {
            this.inner = (Expression)Objects.requireNonNull(inner);
            this.mapper = Objects.requireNonNull(mapper);
        }

        @Override
        public final INNER inner() {
            return this.inner;
        }

        @Override
        public final MAPPER mapper() {
            return this.mapper;
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MapperExpression)) {
                return false;
            }
            MapperExpression that = (MapperExpression)o;
            return Objects.equals(this.inner(), that.inner()) && Objects.equals(this.mapper(), that.mapper()) && Objects.equals((Object)this.mapperType(), (Object)that.mapperType());
        }

        public final int hashCode() {
            return Objects.hash(new Object[]{this.inner(), this.mapper(), this.mapperType()});
        }
    }

    private static abstract class ToBigDecimalMapper<T, INNER extends Expression<T>, MAPPER>
    extends AbstractMapper<T, INNER, MAPPER>
    implements ToBigDecimal<T> {
        ToBigDecimalMapper(INNER inner, MAPPER mapper) {
            super(inner, mapper);
        }
    }

    private static abstract class ToStringMapper<T, INNER extends Expression<T>, MAPPER>
    extends AbstractMapper<T, INNER, MAPPER>
    implements ToString<T> {
        ToStringMapper(INNER inner, MAPPER mapper) {
            super(inner, mapper);
        }
    }

    private static abstract class ToEnumMapper<T, E extends Enum<E>, INNER extends Expression<T>, MAPPER>
    extends AbstractMapper<T, INNER, MAPPER>
    implements ToEnum<T, E> {
        ToEnumMapper(INNER inner, MAPPER mapper) {
            super(inner, mapper);
        }
    }

    private static abstract class ToBooleanMapper<T, INNER extends Expression<T>, MAPPER>
    extends AbstractMapper<T, INNER, MAPPER>
    implements ToBoolean<T> {
        ToBooleanMapper(INNER inner, MAPPER mapper) {
            super(inner, mapper);
        }
    }

    private static abstract class ToCharMapper<T, INNER extends Expression<T>, MAPPER>
    extends AbstractMapper<T, INNER, MAPPER>
    implements ToChar<T> {
        ToCharMapper(INNER inner, MAPPER mapper) {
            super(inner, mapper);
        }
    }

    private static abstract class ToDoubleMapper<T, INNER extends Expression<T>, MAPPER>
    extends AbstractMapper<T, INNER, MAPPER>
    implements ToDouble<T> {
        ToDoubleMapper(INNER inner, MAPPER mapper) {
            super(inner, mapper);
        }
    }

    private static abstract class ToFloatMapper<T, INNER extends Expression<T>, MAPPER>
    extends AbstractMapper<T, INNER, MAPPER>
    implements ToFloat<T> {
        ToFloatMapper(INNER inner, MAPPER mapper) {
            super(inner, mapper);
        }
    }

    private static abstract class ToLongMapper<T, INNER extends Expression<T>, MAPPER>
    extends AbstractMapper<T, INNER, MAPPER>
    implements ToLong<T> {
        ToLongMapper(INNER inner, MAPPER mapper) {
            super(inner, mapper);
        }
    }

    private static abstract class ToIntMapper<T, INNER extends Expression<T>, MAPPER>
    extends AbstractMapper<T, INNER, MAPPER>
    implements ToInt<T> {
        ToIntMapper(INNER inner, MAPPER mapper) {
            super(inner, mapper);
        }
    }

    private static abstract class ToShortMapper<T, INNER extends Expression<T>, MAPPER>
    extends AbstractMapper<T, INNER, MAPPER>
    implements ToShort<T> {
        ToShortMapper(INNER inner, MAPPER mapper) {
            super(inner, mapper);
        }
    }

    private static abstract class ToByteMapper<T, INNER extends Expression<T>, MAPPER>
    extends AbstractMapper<T, INNER, MAPPER>
    implements ToByte<T> {
        ToByteMapper(INNER inner, MAPPER mapper) {
            super(inner, mapper);
        }
    }
}

