/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute.internal.expression;

import com.speedment.runtime.compute.ToByte;
import com.speedment.runtime.compute.ToDouble;
import com.speedment.runtime.compute.ToFloat;
import com.speedment.runtime.compute.ToInt;
import com.speedment.runtime.compute.ToLong;
import com.speedment.runtime.compute.ToShort;
import com.speedment.runtime.compute.expression.BinaryExpression;
import com.speedment.runtime.compute.expression.BinaryObjExpression;
import com.speedment.runtime.compute.expression.Expression;
import java.util.Objects;

public final class MultiplyUtil {
    public static <T> ToInt<T> byteMultiplyByte(ToByte<T> first, byte second) {
        class ByteMultiplyByte
        extends AbstractMultiplyByte<T, ToByte<T>>
        implements ToInt<T> {
            ByteMultiplyByte(ToByte<T> first, byte second) {
                super(first, second, null);
            }

            @Override
            public int applyAsInt(T object) {
                return ((ToByte)this.firstInner).applyAsByte(object) * this.secondInner;
            }
        }
        return new ByteMultiplyByte(first, second);
    }

    public static <T> ToInt<T> byteMultiplyInt(ToByte<T> first, int second) {
        class ByteMultiplyInt
        extends AbstractMultiplyInt<T, ToByte<T>>
        implements ToInt<T> {
            ByteMultiplyInt(ToByte<T> first, int second) {
                super(first, second, null);
            }

            @Override
            public int applyAsInt(T object) {
                return ((ToByte)this.firstInner).applyAsByte(object) * this.secondInner;
            }
        }
        return new ByteMultiplyInt(first, second);
    }

    public static <T> ToLong<T> byteMultiplyLong(ToByte<T> first, long second) {
        class ByteMultiplyLong
        extends AbstractMultiplyLong<T, ToByte<T>>
        implements ToLong<T> {
            ByteMultiplyLong(ToByte<T> first, long second) {
                super(first, second, null);
            }

            @Override
            public long applyAsLong(T object) {
                return (long)((ToByte)this.firstInner).applyAsByte(object) * this.secondInner;
            }
        }
        return new ByteMultiplyLong(first, second);
    }

    public static <T> ToInt<T> byteMultiplyByte(ToByte<T> first, ToByte<T> second) {
        class ByteMultiplyByte
        extends AbstractMultiply<T, ToByte<T>, ToByte<T>>
        implements ToInt<T> {
            ByteMultiplyByte(ToByte<T> first, ToByte<T> second) {
                super(first, second, null);
            }

            @Override
            public int applyAsInt(T object) {
                return ((ToByte)this.firstInner).applyAsByte(object) * ((ToByte)this.secondInner).applyAsByte(object);
            }
        }
        return new ByteMultiplyByte(first, second);
    }

    public static <T> ToInt<T> shortMultiplyByte(ToShort<T> first, byte second) {
        class ShortMultiplyShort
        extends AbstractMultiplyByte<T, ToShort<T>>
        implements ToInt<T> {
            ShortMultiplyShort(ToShort<T> first, byte second) {
                super(first, second, null);
            }

            @Override
            public int applyAsInt(T object) {
                return ((ToShort)this.firstInner).applyAsShort(object) * this.secondInner;
            }
        }
        return new ShortMultiplyShort(first, second);
    }

    public static <T> ToInt<T> shortMultiplyInt(ToShort<T> first, int second) {
        class ShortMultiplyInt
        extends AbstractMultiplyInt<T, ToShort<T>>
        implements ToInt<T> {
            ShortMultiplyInt(ToShort<T> first, int second) {
                super(first, second, null);
            }

            @Override
            public int applyAsInt(T object) {
                return ((ToShort)this.firstInner).applyAsShort(object) * this.secondInner;
            }
        }
        return new ShortMultiplyInt(first, second);
    }

    public static <T> ToLong<T> shortMultiplyLong(ToShort<T> first, long second) {
        class ShortMultiplyLong
        extends AbstractMultiplyLong<T, ToShort<T>>
        implements ToLong<T> {
            ShortMultiplyLong(ToShort<T> first, long second) {
                super(first, second, null);
            }

            @Override
            public long applyAsLong(T object) {
                return (long)((ToShort)this.firstInner).applyAsShort(object) * this.secondInner;
            }
        }
        return new ShortMultiplyLong(first, second);
    }

    public static <T> ToInt<T> shortMultiplyShort(ToShort<T> first, ToShort<T> second) {
        class ShortMultiplyShort
        extends AbstractMultiply<T, ToShort<T>, ToShort<T>>
        implements ToInt<T> {
            ShortMultiplyShort(ToShort<T> first, ToShort<T> second) {
                super(first, second, null);
            }

            @Override
            public int applyAsInt(T object) {
                return ((ToShort)this.firstInner).applyAsShort(object) * ((ToShort)this.secondInner).applyAsShort(object);
            }
        }
        return new ShortMultiplyShort(first, second);
    }

    public static <T> ToInt<T> intMultiplyByte(ToInt<T> first, byte second) {
        class IntMultiplyByte
        extends AbstractMultiplyByte<T, ToInt<T>>
        implements ToInt<T> {
            IntMultiplyByte(ToInt<T> first, byte second) {
                super(first, second, null);
            }

            @Override
            public int applyAsInt(T object) {
                return ((ToInt)this.firstInner).applyAsInt(object) * this.secondInner;
            }
        }
        return new IntMultiplyByte(first, second);
    }

    public static <T> ToInt<T> intMultiplyInt(ToInt<T> first, int second) {
        class IntMultiplyInt
        extends AbstractMultiplyInt<T, ToInt<T>>
        implements ToInt<T> {
            IntMultiplyInt(ToInt<T> first, int second) {
                super(first, second, null);
            }

            @Override
            public int applyAsInt(T object) {
                return ((ToInt)this.firstInner).applyAsInt(object) * this.secondInner;
            }
        }
        return new IntMultiplyInt(first, second);
    }

    public static <T> ToLong<T> intMultiplyLong(ToInt<T> first, long second) {
        class IntMultiplyLong
        extends AbstractMultiplyLong<T, ToInt<T>>
        implements ToLong<T> {
            IntMultiplyLong(ToInt<T> first, long second) {
                super(first, second, null);
            }

            @Override
            public long applyAsLong(T object) {
                return (long)((ToInt)this.firstInner).applyAsInt(object) * this.secondInner;
            }
        }
        return new IntMultiplyLong(first, second);
    }

    public static <T> ToInt<T> intMultiplyByte(ToInt<T> first, ToByte<T> second) {
        class IntMultiplyByte
        extends AbstractMultiply<T, ToInt<T>, ToByte<T>>
        implements ToInt<T> {
            IntMultiplyByte(ToInt<T> first, ToByte<T> second) {
                super(first, second, null);
            }

            @Override
            public int applyAsInt(T object) {
                return ((ToInt)this.firstInner).applyAsInt(object) * ((ToByte)this.secondInner).applyAsByte(object);
            }
        }
        return new IntMultiplyByte(first, second);
    }

    public static <T> ToInt<T> intMultiplyInt(ToInt<T> first, ToInt<T> second) {
        class IntMultiplyInt
        extends AbstractMultiply<T, ToInt<T>, ToInt<T>>
        implements ToInt<T> {
            IntMultiplyInt(ToInt<T> first, ToInt<T> second) {
                super(first, second, null);
            }

            @Override
            public int applyAsInt(T object) {
                return ((ToInt)this.firstInner).applyAsInt(object) * ((ToInt)this.secondInner).applyAsInt(object);
            }
        }
        return new IntMultiplyInt(first, second);
    }

    public static <T> ToLong<T> longMultiplyByte(ToLong<T> first, byte second) {
        class LongMultiplyLong
        extends AbstractMultiplyByte<T, ToLong<T>>
        implements ToLong<T> {
            LongMultiplyLong(ToLong<T> first, byte second) {
                super(first, second, null);
            }

            @Override
            public long applyAsLong(T object) {
                return ((ToLong)this.firstInner).applyAsLong(object) * (long)this.secondInner;
            }
        }
        return new LongMultiplyLong(first, second);
    }

    public static <T> ToLong<T> longMultiplyInt(ToLong<T> first, int second) {
        class LongMultiplyInt
        extends AbstractMultiplyInt<T, ToLong<T>>
        implements ToLong<T> {
            LongMultiplyInt(ToLong<T> first, int second) {
                super(first, second, null);
            }

            @Override
            public long applyAsLong(T object) {
                return ((ToLong)this.firstInner).applyAsLong(object) * (long)this.secondInner;
            }
        }
        return new LongMultiplyInt(first, second);
    }

    public static <T> ToLong<T> longMultiplyLong(ToLong<T> first, long second) {
        class LongMultiplyLong
        extends AbstractMultiplyLong<T, ToLong<T>>
        implements ToLong<T> {
            LongMultiplyLong(ToLong<T> first, long second) {
                super(first, second, null);
            }

            @Override
            public long applyAsLong(T object) {
                return ((ToLong)this.firstInner).applyAsLong(object) * this.secondInner;
            }
        }
        return new LongMultiplyLong(first, second);
    }

    public static <T> ToLong<T> longMultiplyInt(ToLong<T> first, ToInt<T> second) {
        class LongMultiplyInt
        extends AbstractMultiply<T, ToLong<T>, ToInt<T>>
        implements ToLong<T> {
            LongMultiplyInt(ToLong<T> first, ToInt<T> second) {
                super(first, second, null);
            }

            @Override
            public long applyAsLong(T object) {
                return ((ToLong)this.firstInner).applyAsLong(object) * (long)((ToInt)this.secondInner).applyAsInt(object);
            }
        }
        return new LongMultiplyInt(first, second);
    }

    public static <T> ToLong<T> longMultiplyLong(ToLong<T> first, ToLong<T> second) {
        class LongMultiplyLong
        extends AbstractMultiply<T, ToLong<T>, ToLong<T>>
        implements ToLong<T> {
            LongMultiplyLong(ToLong<T> first, ToLong<T> second) {
                super(first, second, null);
            }

            @Override
            public long applyAsLong(T object) {
                return ((ToLong)this.firstInner).applyAsLong(object) * ((ToLong)this.secondInner).applyAsLong(object);
            }
        }
        return new LongMultiplyLong(first, second);
    }

    public static <T> ToFloat<T> floatMultiplyInt(ToFloat<T> first, int second) {
        class FloatMultiplyInt
        extends AbstractMultiplyInt<T, ToFloat<T>>
        implements ToFloat<T> {
            FloatMultiplyInt(ToFloat<T> first, int second) {
                super(first, second, null);
            }

            @Override
            public float applyAsFloat(T object) {
                return ((ToFloat)this.firstInner).applyAsFloat(object) * (float)this.secondInner;
            }
        }
        return new FloatMultiplyInt(first, second);
    }

    public static <T> ToDouble<T> floatMultiplyLong(ToFloat<T> first, long second) {
        class FloatMultiplyLong
        extends AbstractMultiplyLong<T, ToFloat<T>>
        implements ToDouble<T> {
            FloatMultiplyLong(ToFloat<T> first, long second) {
                super(first, second, null);
            }

            @Override
            public double applyAsDouble(T object) {
                return ((ToFloat)this.firstInner).applyAsFloat(object) * (float)this.secondInner;
            }
        }
        return new FloatMultiplyLong(first, second);
    }

    public static <T> ToFloat<T> floatMultiplyFloat(ToFloat<T> first, float second) {
        class FloatMultiplyFloat
        extends AbstractMultiplyFloat<T, ToFloat<T>>
        implements ToFloat<T> {
            FloatMultiplyFloat(ToFloat<T> first, float second) {
                super(first, second, null);
            }

            @Override
            public float applyAsFloat(T object) {
                return ((ToFloat)this.firstInner).applyAsFloat(object) * this.secondInner;
            }
        }
        return new FloatMultiplyFloat(first, second);
    }

    public static <T> ToFloat<T> floatMultiplyInt(ToFloat<T> first, ToInt<T> second) {
        class FloatMultiplyInt
        extends AbstractMultiply<T, ToFloat<T>, ToInt<T>>
        implements ToFloat<T> {
            FloatMultiplyInt(ToFloat<T> first, ToInt<T> second) {
                super(first, second, null);
            }

            @Override
            public float applyAsFloat(T object) {
                return ((ToFloat)this.firstInner).applyAsFloat(object) * (float)((ToInt)this.secondInner).applyAsInt(object);
            }
        }
        return new FloatMultiplyInt(first, second);
    }

    public static <T> ToDouble<T> floatMultiplyLong(ToFloat<T> first, ToLong<T> second) {
        class FloatMultiplyLong
        extends AbstractMultiply<T, ToFloat<T>, ToLong<T>>
        implements ToDouble<T> {
            FloatMultiplyLong(ToFloat<T> first, ToLong<T> second) {
                super(first, second, null);
            }

            @Override
            public double applyAsDouble(T object) {
                return ((ToFloat)this.firstInner).applyAsFloat(object) * (float)((ToLong)this.secondInner).applyAsLong(object);
            }
        }
        return new FloatMultiplyLong(first, second);
    }

    public static <T> ToFloat<T> floatMultiplyFloat(ToFloat<T> first, ToFloat<T> second) {
        class FloatMultiplyFloat
        extends AbstractMultiply<T, ToFloat<T>, ToFloat<T>>
        implements ToFloat<T> {
            FloatMultiplyFloat(ToFloat<T> first, ToFloat<T> second) {
                super(first, second, null);
            }

            @Override
            public float applyAsFloat(T object) {
                return ((ToFloat)this.firstInner).applyAsFloat(object) * ((ToFloat)this.secondInner).applyAsFloat(object);
            }
        }
        return new FloatMultiplyFloat(first, second);
    }

    public static <T> ToDouble<T> doubleMultiplyInt(ToDouble<T> first, int second) {
        class DoubleMultiplyInt
        extends AbstractMultiplyInt<T, ToDouble<T>>
        implements ToDouble<T> {
            DoubleMultiplyInt(ToDouble<T> first, int second) {
                super(first, second, null);
            }

            @Override
            public double applyAsDouble(T object) {
                return ((ToDouble)this.firstInner).applyAsDouble(object) * (double)this.secondInner;
            }
        }
        return new DoubleMultiplyInt(first, second);
    }

    public static <T> ToDouble<T> doubleMultiplyLong(ToDouble<T> first, long second) {
        class DoubleMultiplyLong
        extends AbstractMultiplyLong<T, ToDouble<T>>
        implements ToDouble<T> {
            DoubleMultiplyLong(ToDouble<T> first, long second) {
                super(first, second, null);
            }

            @Override
            public double applyAsDouble(T object) {
                return ((ToDouble)this.firstInner).applyAsDouble(object) * (double)this.secondInner;
            }
        }
        return new DoubleMultiplyLong(first, second);
    }

    public static <T> ToDouble<T> doubleMultiplyDouble(ToDouble<T> first, double second) {
        class DoubleMultiplyDouble
        extends AbstractMultiplyDouble<T, ToDouble<T>>
        implements ToDouble<T> {
            DoubleMultiplyDouble(ToDouble<T> first, double second) {
                super(first, second, null);
            }

            @Override
            public double applyAsDouble(T object) {
                return ((ToDouble)this.firstInner).applyAsDouble(object) * this.secondInner;
            }
        }
        return new DoubleMultiplyDouble(first, second);
    }

    public static <T> ToDouble<T> doubleMultiplyInt(ToDouble<T> first, ToInt<T> second) {
        class DoubleMultiplyInt
        extends AbstractMultiply<T, ToDouble<T>, ToInt<T>>
        implements ToDouble<T> {
            DoubleMultiplyInt(ToDouble<T> first, ToInt<T> second) {
                super(first, second, null);
            }

            @Override
            public double applyAsDouble(T object) {
                return ((ToDouble)this.firstInner).applyAsDouble(object) * (double)((ToInt)this.secondInner).applyAsInt(object);
            }
        }
        return new DoubleMultiplyInt(first, second);
    }

    public static <T> ToDouble<T> doubleMultiplyLong(ToDouble<T> first, ToLong<T> second) {
        class DoubleMultiplyLong
        extends AbstractMultiply<T, ToDouble<T>, ToLong<T>>
        implements ToDouble<T> {
            DoubleMultiplyLong(ToDouble<T> first, ToLong<T> second) {
                super(first, second, null);
            }

            @Override
            public double applyAsDouble(T object) {
                return ((ToDouble)this.firstInner).applyAsDouble(object) * (double)((ToLong)this.secondInner).applyAsLong(object);
            }
        }
        return new DoubleMultiplyLong(first, second);
    }

    public static <T> ToDouble<T> doubleMultiplyDouble(ToDouble<T> first, ToDouble<T> second) {
        class DoubleMultiplyDouble
        extends AbstractMultiply<T, ToDouble<T>, ToDouble<T>>
        implements ToDouble<T> {
            DoubleMultiplyDouble(ToDouble<T> first, ToDouble<T> second) {
                super(first, second, null);
            }

            @Override
            public double applyAsDouble(T object) {
                return ((ToDouble)this.firstInner).applyAsDouble(object) * ((ToDouble)this.secondInner).applyAsDouble(object);
            }
        }
        return new DoubleMultiplyDouble(first, second);
    }

    private MultiplyUtil() {
    }

    private static abstract class AbstractMultiplyDouble<T, INNER extends Expression<T>>
    implements BinaryObjExpression<T, INNER, Double> {
        final INNER firstInner;
        final double secondInner;

        private AbstractMultiplyDouble(INNER first, double second) {
            this.firstInner = (Expression)Objects.requireNonNull(first);
            this.secondInner = second;
        }

        @Override
        public final INNER first() {
            return this.firstInner;
        }

        @Override
        public final Double second() {
            return this.secondInner;
        }

        @Override
        public final BinaryObjExpression.Operator operator() {
            return BinaryObjExpression.Operator.MULTIPLY;
        }

        public final boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (!(o instanceof BinaryObjExpression)) {
                return false;
            }
            BinaryObjExpression that = (BinaryObjExpression)o;
            return Objects.equals(this.firstInner, that.first()) && Objects.equals(this.secondInner, that.second()) && Objects.equals((Object)this.operator(), (Object)that.operator());
        }

        public final int hashCode() {
            return Objects.hash(new Object[]{this.firstInner, this.secondInner, this.operator()});
        }

        /* synthetic */ AbstractMultiplyDouble(Expression x0, double x1, 1 x2) {
            this(x0, x1);
        }
    }

    private static abstract class AbstractMultiplyFloat<T, INNER extends Expression<T>>
    implements BinaryObjExpression<T, INNER, Float> {
        final INNER firstInner;
        final float secondInner;

        private AbstractMultiplyFloat(INNER first, float second) {
            this.firstInner = (Expression)Objects.requireNonNull(first);
            this.secondInner = second;
        }

        @Override
        public final INNER first() {
            return this.firstInner;
        }

        @Override
        public final Float second() {
            return Float.valueOf(this.secondInner);
        }

        @Override
        public final BinaryObjExpression.Operator operator() {
            return BinaryObjExpression.Operator.MULTIPLY;
        }

        public final boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (!(o instanceof BinaryObjExpression)) {
                return false;
            }
            BinaryObjExpression that = (BinaryObjExpression)o;
            return Objects.equals(this.firstInner, that.first()) && Objects.equals(Float.valueOf(this.secondInner), that.second()) && Objects.equals((Object)this.operator(), (Object)that.operator());
        }

        public final int hashCode() {
            return Objects.hash(new Object[]{this.firstInner, Float.valueOf(this.secondInner), this.operator()});
        }

        /* synthetic */ AbstractMultiplyFloat(Expression x0, float x1, 1 x2) {
            this(x0, x1);
        }
    }

    private static abstract class AbstractMultiplyLong<T, INNER extends Expression<T>>
    implements BinaryObjExpression<T, INNER, Long> {
        final INNER firstInner;
        final long secondInner;

        private AbstractMultiplyLong(INNER first, long second) {
            this.firstInner = (Expression)Objects.requireNonNull(first);
            this.secondInner = second;
        }

        @Override
        public final INNER first() {
            return this.firstInner;
        }

        @Override
        public final Long second() {
            return this.secondInner;
        }

        @Override
        public final BinaryObjExpression.Operator operator() {
            return BinaryObjExpression.Operator.MULTIPLY;
        }

        public final boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (!(o instanceof BinaryObjExpression)) {
                return false;
            }
            BinaryObjExpression that = (BinaryObjExpression)o;
            return Objects.equals(this.firstInner, that.first()) && Objects.equals(this.secondInner, that.second()) && Objects.equals((Object)this.operator(), (Object)that.operator());
        }

        public final int hashCode() {
            return Objects.hash(new Object[]{this.firstInner, this.secondInner, this.operator()});
        }

        /* synthetic */ AbstractMultiplyLong(Expression x0, long x1, 1 x2) {
            this(x0, x1);
        }
    }

    private static abstract class AbstractMultiplyInt<T, INNER extends Expression<T>>
    implements BinaryObjExpression<T, INNER, Integer> {
        final INNER firstInner;
        final int secondInner;

        private AbstractMultiplyInt(INNER first, int second) {
            this.firstInner = (Expression)Objects.requireNonNull(first);
            this.secondInner = second;
        }

        @Override
        public final INNER first() {
            return this.firstInner;
        }

        @Override
        public final Integer second() {
            return this.secondInner;
        }

        @Override
        public final BinaryObjExpression.Operator operator() {
            return BinaryObjExpression.Operator.MULTIPLY;
        }

        public final boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (!(o instanceof BinaryObjExpression)) {
                return false;
            }
            BinaryObjExpression that = (BinaryObjExpression)o;
            return Objects.equals(this.firstInner, that.first()) && Objects.equals(this.secondInner, that.second()) && Objects.equals((Object)this.operator(), (Object)that.operator());
        }

        public final int hashCode() {
            return Objects.hash(new Object[]{this.firstInner, this.secondInner, this.operator()});
        }

        /* synthetic */ AbstractMultiplyInt(Expression x0, int x1, 1 x2) {
            this(x0, x1);
        }
    }

    private static abstract class AbstractMultiplyByte<T, INNER extends Expression<T>>
    implements BinaryObjExpression<T, INNER, Byte> {
        final INNER firstInner;
        final byte secondInner;

        private AbstractMultiplyByte(INNER first, byte second) {
            this.firstInner = (Expression)Objects.requireNonNull(first);
            this.secondInner = second;
        }

        @Override
        public final INNER first() {
            return this.firstInner;
        }

        @Override
        public final Byte second() {
            return this.secondInner;
        }

        @Override
        public final BinaryObjExpression.Operator operator() {
            return BinaryObjExpression.Operator.MULTIPLY;
        }

        public final boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (!(o instanceof BinaryObjExpression)) {
                return false;
            }
            BinaryObjExpression that = (BinaryObjExpression)o;
            return Objects.equals(this.firstInner, that.first()) && Objects.equals(this.secondInner, that.second()) && Objects.equals((Object)this.operator(), (Object)that.operator());
        }

        public final int hashCode() {
            return Objects.hash(new Object[]{this.firstInner, this.secondInner, this.operator()});
        }

        /* synthetic */ AbstractMultiplyByte(Expression x0, byte x1, 1 x2) {
            this(x0, x1);
        }
    }

    private static abstract class AbstractMultiply<T, FIRST extends Expression<T>, SECOND extends Expression<T>>
    implements BinaryExpression<T, FIRST, SECOND> {
        final FIRST firstInner;
        final SECOND secondInner;

        private AbstractMultiply(FIRST first, SECOND second) {
            this.firstInner = (Expression)Objects.requireNonNull(first);
            this.secondInner = (Expression)Objects.requireNonNull(second);
        }

        @Override
        public final FIRST first() {
            return this.firstInner;
        }

        @Override
        public final SECOND second() {
            return this.secondInner;
        }

        @Override
        public final BinaryExpression.Operator operator() {
            return BinaryExpression.Operator.MULTIPLY;
        }

        public final boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (!(o instanceof BinaryExpression)) {
                return false;
            }
            BinaryExpression that = (BinaryExpression)o;
            return Objects.equals(this.firstInner, that.first()) && Objects.equals(this.secondInner, that.second()) && Objects.equals((Object)this.operator(), (Object)that.operator());
        }

        public final int hashCode() {
            return Objects.hash(new Object[]{this.firstInner, this.secondInner, this.operator()});
        }

        /* synthetic */ AbstractMultiply(Expression x0, Expression x1, 1 x2) {
            this(x0, x1);
        }
    }
}

