/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute.internal.expression;

import com.speedment.runtime.compute.ToBigDecimal;
import com.speedment.runtime.compute.ToByte;
import com.speedment.runtime.compute.ToDouble;
import com.speedment.runtime.compute.ToFloat;
import com.speedment.runtime.compute.ToInt;
import com.speedment.runtime.compute.ToLong;
import com.speedment.runtime.compute.ToShort;
import com.speedment.runtime.compute.expression.Expression;
import com.speedment.runtime.compute.expression.UnaryExpression;
import java.math.BigDecimal;
import java.util.Objects;

public final class SignUtil {
    private static final byte NEGATIVE = -1;
    private static final byte POSITIVE = 1;
    private static final byte ZERO = 0;

    public static <T> ToByte<T> signBigDecimal(ToBigDecimal<T> expression) {
        class BigDecimalSign
        extends AbstractSign<T, ToBigDecimal<T>> {
            BigDecimalSign(ToBigDecimal<T> tToBigDecimal) {
                super(tToBigDecimal);
            }

            @Override
            public byte applyAsByte(T object) {
                return (byte)((BigDecimal)((ToBigDecimal)this.inner).apply(object)).signum();
            }
        }
        return new BigDecimalSign(expression);
    }

    public static <T> ToByte<T> signDouble(ToDouble<T> expression) {
        class DoubleSign
        extends AbstractSign<T, ToDouble<T>> {
            DoubleSign(ToDouble<T> tToDouble) {
                super(tToDouble);
            }

            @Override
            public byte applyAsByte(T object) {
                double value = ((ToDouble)this.inner).applyAsDouble(object);
                return value < 0.0 ? (byte)-1 : (value > 0.0 ? (byte)1 : 0);
            }
        }
        return new DoubleSign(expression);
    }

    public static <T> ToByte<T> signFloat(ToFloat<T> expression) {
        class FloatSign
        extends AbstractSign<T, ToFloat<T>> {
            FloatSign(ToFloat<T> tToFloat) {
                super(tToFloat);
            }

            @Override
            public byte applyAsByte(T object) {
                float value = ((ToFloat)this.inner).applyAsFloat(object);
                return value < 0.0f ? (byte)-1 : (value > 0.0f ? (byte)1 : 0);
            }
        }
        return new FloatSign(expression);
    }

    public static <T> ToByte<T> signLong(ToLong<T> expression) {
        class LongSign
        extends AbstractSign<T, ToLong<T>> {
            LongSign(ToLong<T> tToLong) {
                super(tToLong);
            }

            @Override
            public byte applyAsByte(T object) {
                long value = ((ToLong)this.inner).applyAsLong(object);
                return value < 0L ? (byte)-1 : (value > 0L ? (byte)1 : 0);
            }
        }
        return new LongSign(expression);
    }

    public static <T> ToByte<T> signInt(ToInt<T> expression) {
        class IntSign
        extends AbstractSign<T, ToInt<T>> {
            IntSign(ToInt<T> tToInt) {
                super(tToInt);
            }

            @Override
            public byte applyAsByte(T object) {
                int value = ((ToInt)this.inner).applyAsInt(object);
                return value < 0 ? (byte)-1 : (value > 0 ? (byte)1 : 0);
            }
        }
        return new IntSign(expression);
    }

    public static <T> ToByte<T> signShort(ToShort<T> expression) {
        class ShortSign
        extends AbstractSign<T, ToShort<T>> {
            ShortSign(ToShort<T> tToShort) {
                super(tToShort);
            }

            @Override
            public byte applyAsByte(T object) {
                short value = ((ToShort)this.inner).applyAsShort(object);
                return value < 0 ? (byte)-1 : (value > 0 ? (byte)1 : 0);
            }
        }
        return new ShortSign(expression);
    }

    public static <T> ToByte<T> signByte(ToByte<T> expression) {
        class ByteSign
        extends AbstractSign<T, ToByte<T>> {
            ByteSign(ToByte<T> tToByte) {
                super(tToByte);
            }

            @Override
            public byte applyAsByte(T object) {
                byte value = ((ToByte)this.inner).applyAsByte(object);
                return value < 0 ? (byte)-1 : (value > 0 ? (byte)1 : 0);
            }
        }
        return new ByteSign(expression);
    }

    private SignUtil() {
    }

    private static abstract class AbstractSign<T, INNER extends Expression<T>>
    implements UnaryExpression<T, INNER>,
    ToByte<T> {
        final INNER inner;

        AbstractSign(INNER inner) {
            this.inner = (Expression)Objects.requireNonNull(inner);
        }

        @Override
        public final INNER inner() {
            return this.inner;
        }

        @Override
        public final UnaryExpression.Operator operator() {
            return UnaryExpression.Operator.SIGN;
        }

        @Override
        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UnaryExpression)) {
                return false;
            }
            UnaryExpression that = (UnaryExpression)o;
            return Objects.equals(this.inner(), that.inner()) && Objects.equals((Object)this.operator(), (Object)that.operator());
        }

        public final int hashCode() {
            return Objects.hash(new Object[]{this.inner(), this.operator()});
        }
    }
}

