/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute.internal.expression;

import com.speedment.runtime.compute.ToByte;
import com.speedment.runtime.compute.ToDouble;
import com.speedment.runtime.compute.ToFloat;
import com.speedment.runtime.compute.ToInt;
import com.speedment.runtime.compute.ToLong;
import com.speedment.runtime.compute.ToShort;
import com.speedment.runtime.compute.expression.Expression;
import com.speedment.runtime.compute.expression.UnaryExpression;
import java.util.Objects;

public final class SqrtUtil {
    public static <T> ToDouble<T> sqrtByte(ToByte<T> other) {
        class ByteSqrt
        extends AbstractSqrt<T, ToByte<T>> {
            ByteSqrt(ToByte<T> tToByte) {
                super(tToByte);
            }

            @Override
            public double applyAsDouble(T object) {
                return Math.sqrt(((ToByte)this.inner).applyAsByte(object));
            }
        }
        return new ByteSqrt(other);
    }

    public static <T> ToDouble<T> sqrtShort(ToShort<T> other) {
        class ShortSqrt
        extends AbstractSqrt<T, ToShort<T>> {
            ShortSqrt(ToShort<T> tToShort) {
                super(tToShort);
            }

            @Override
            public double applyAsDouble(T object) {
                return Math.sqrt(((ToShort)this.inner).applyAsShort(object));
            }
        }
        return new ShortSqrt(other);
    }

    public static <T> ToDouble<T> sqrtInt(ToInt<T> other) {
        class IntSqrt
        extends AbstractSqrt<T, ToInt<T>> {
            IntSqrt(ToInt<T> tToInt) {
                super(tToInt);
            }

            @Override
            public double applyAsDouble(T object) {
                return Math.sqrt(((ToInt)this.inner).applyAsInt(object));
            }
        }
        return new IntSqrt(other);
    }

    public static <T> ToDouble<T> sqrtLong(ToLong<T> other) {
        class LongSqrt
        extends AbstractSqrt<T, ToLong<T>> {
            LongSqrt(ToLong<T> tToLong) {
                super(tToLong);
            }

            @Override
            public double applyAsDouble(T object) {
                return Math.sqrt(((ToLong)this.inner).applyAsLong(object));
            }
        }
        return new LongSqrt(other);
    }

    public static <T> ToDouble<T> sqrtFloat(ToFloat<T> other) {
        class FloatSqrt
        extends AbstractSqrt<T, ToFloat<T>> {
            FloatSqrt(ToFloat<T> tToFloat) {
                super(tToFloat);
            }

            @Override
            public double applyAsDouble(T object) {
                return Math.sqrt(((ToFloat)this.inner).applyAsFloat(object));
            }
        }
        return new FloatSqrt(other);
    }

    public static <T> ToDouble<T> sqrtDouble(ToDouble<T> other) {
        class DoubleSqrt
        extends AbstractSqrt<T, ToDouble<T>> {
            DoubleSqrt(ToDouble<T> tToDouble) {
                super(tToDouble);
            }

            @Override
            public double applyAsDouble(T object) {
                return Math.sqrt(((ToDouble)this.inner).applyAsDouble(object));
            }
        }
        return new DoubleSqrt(other);
    }

    private SqrtUtil() {
    }

    private static abstract class AbstractSqrt<T, INNER extends Expression<T>>
    implements UnaryExpression<T, INNER>,
    ToDouble<T> {
        final INNER inner;

        AbstractSqrt(INNER inner) {
            this.inner = (Expression)Objects.requireNonNull(inner);
        }

        @Override
        public final INNER inner() {
            return this.inner;
        }

        @Override
        public final UnaryExpression.Operator operator() {
            return UnaryExpression.Operator.SQRT;
        }

        @Override
        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UnaryExpression)) {
                return false;
            }
            UnaryExpression that = (UnaryExpression)o;
            return Objects.equals(this.inner(), that.inner()) && Objects.equals((Object)this.operator(), (Object)that.operator());
        }

        public final int hashCode() {
            return Objects.hash(new Object[]{this.inner(), this.operator()});
        }
    }
}

