/*
 *
 * Copyright (c) 2006-2020, Speedment, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); You may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.speedment.runtime.compute.trait;

/**
 * Trait for expressions that has a {@link #abs()} method for getting the
 * absolute value of the result from the current expression.
 *
 * @param <E>  the expression type returned by the {@link #abs()} method
 *
 * @author Emil Forslund
 * @since  3.1.0
 */
public interface HasAbs<E extends HasAbs<E>> {

    /**
     * Returns a new expression that returns the absolute value of the result
     * of the current expression.
     *
     * @return  the new expression
     */
    E abs();

}
