/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute;

import com.speedment.common.function.CharUnaryOperator;
import com.speedment.common.function.ToCharFunction;
import com.speedment.runtime.compute.ToCharNullable;
import com.speedment.runtime.compute.ToDouble;
import com.speedment.runtime.compute.ToInt;
import com.speedment.runtime.compute.ToLong;
import com.speedment.runtime.compute.expression.Expression;
import com.speedment.runtime.compute.expression.ExpressionType;
import com.speedment.runtime.compute.internal.expression.CastUtil;
import com.speedment.runtime.compute.internal.expression.ComposedUtil;
import com.speedment.runtime.compute.internal.expression.MapperUtil;
import com.speedment.runtime.compute.trait.HasAsDouble;
import com.speedment.runtime.compute.trait.HasAsInt;
import com.speedment.runtime.compute.trait.HasAsLong;
import com.speedment.runtime.compute.trait.HasCase;
import com.speedment.runtime.compute.trait.HasCompare;
import com.speedment.runtime.compute.trait.HasCompose;
import com.speedment.runtime.compute.trait.HasHash;
import com.speedment.runtime.compute.trait.HasMap;
import java.util.function.Function;

@FunctionalInterface
public interface ToChar<T>
extends Expression<T>,
ToCharFunction<T>,
HasAsDouble<T>,
HasAsInt<T>,
HasAsLong<T>,
HasMap<T, CharUnaryOperator, ToChar<T>>,
HasCase<T, ToChar<T>>,
HasHash<T>,
HasCompare<T>,
HasCompose<T> {
    public static <T> ToChar<T> of(ToCharFunction<T> lambda) {
        if (lambda instanceof ToChar) {
            return (ToChar)lambda;
        }
        return arg_0 -> lambda.applyAsChar(arg_0);
    }

    @Override
    default public ExpressionType expressionType() {
        return ExpressionType.CHAR;
    }

    @Override
    default public ToDouble<T> asDouble() {
        return CastUtil.castCharToDouble(this);
    }

    @Override
    default public ToInt<T> asInt() {
        return CastUtil.castCharToInt(this);
    }

    @Override
    default public ToLong<T> asLong() {
        return CastUtil.castCharToLong(this);
    }

    @Override
    default public ToChar<T> map(CharUnaryOperator operator) {
        return MapperUtil.mapChar(this, operator);
    }

    @Override
    default public ToChar<T> toUpperCase() {
        return this.map(Character::toUpperCase);
    }

    @Override
    default public ToChar<T> toLowerCase() {
        return this.map(Character::toLowerCase);
    }

    @Override
    default public long hash(T object) {
        return this.applyAsChar(object);
    }

    @Override
    default public int compare(T first, T second) {
        char f = this.applyAsChar(first);
        char s = this.applyAsChar(second);
        return Character.compare(f, s);
    }

    @Override
    default public <V> ToCharNullable<V> compose(Function<? super V, ? extends T> before) {
        Function<? super V, ? extends T> casted = before;
        return ComposedUtil.composeToChar(casted, this);
    }
}

