/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute;

import com.speedment.runtime.compute.ToDouble;
import com.speedment.runtime.compute.ToDoubleNullable;
import com.speedment.runtime.compute.ToEnum;
import com.speedment.runtime.compute.ToIntNullable;
import com.speedment.runtime.compute.ToStringNullable;
import com.speedment.runtime.compute.expression.Expression;
import com.speedment.runtime.compute.expression.ExpressionType;
import com.speedment.runtime.compute.internal.ToEnumImpl;
import com.speedment.runtime.compute.internal.ToEnumNullableImpl;
import com.speedment.runtime.compute.internal.expression.ComposedUtil;
import com.speedment.runtime.compute.internal.expression.OrElseGetUtil;
import com.speedment.runtime.compute.internal.expression.OrElseThrowUtil;
import com.speedment.runtime.compute.internal.expression.OrElseUtil;
import com.speedment.runtime.compute.trait.HasCompare;
import com.speedment.runtime.compute.trait.HasCompose;
import com.speedment.runtime.compute.trait.HasHash;
import com.speedment.runtime.compute.trait.HasMapIfPresent;
import com.speedment.runtime.compute.trait.HasMapToDoubleIfPresent;
import com.speedment.runtime.compute.trait.ToNullable;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.UnaryOperator;

public interface ToEnumNullable<T, E extends Enum<E>>
extends Expression<T>,
ToNullable<T, E, ToEnum<T, E>>,
HasMapToDoubleIfPresent<T, ToDoubleFunction<E>>,
HasMapIfPresent<T, UnaryOperator<E>, ToEnumNullable<T, E>>,
HasHash<T>,
HasCompare<T>,
HasCompose<T> {
    public static <T, E extends Enum<E>> ToEnumNullable<T, E> of(Class<E> enumClass, Function<T, E> lambda) {
        return new ToEnumNullableImpl<T, E>(enumClass, lambda);
    }

    public Class<E> enumClass();

    @Override
    default public ExpressionType expressionType() {
        return ExpressionType.ENUM_NULLABLE;
    }

    default public ToIntNullable<T> asOrdinal() {
        return t -> this.isNotNull(t) ? Integer.valueOf(((Enum)this.apply(t)).ordinal()) : null;
    }

    default public ToStringNullable<T> asName() {
        return t -> this.isNotNull(t) ? ((Enum)this.apply(t)).name() : null;
    }

    @Override
    default public ToEnum<T, E> orThrow() {
        return OrElseThrowUtil.enumOrElseThrow(this);
    }

    @Override
    default public ToEnum<T, E> orElseGet(ToEnum<T, E> getter) {
        return OrElseGetUtil.enumOrElseGet(this, getter);
    }

    @Override
    default public ToEnum<T, E> orElse(E value) {
        return OrElseUtil.enumOrElse(this, value);
    }

    @Override
    default public ToDoubleNullable<T> mapToDoubleIfPresent(final ToDoubleFunction<E> mapper) {
        final ToEnumNullable delegate = this;
        return new ToDoubleNullable<T>(){

            @Override
            public Double apply(T object) {
                return delegate.isNull(object) ? null : Double.valueOf(mapper.applyAsDouble((Enum)delegate.apply(object)));
            }

            @Override
            public double applyAsDouble(T object) {
                return mapper.applyAsDouble((Enum)delegate.apply(object));
            }

            @Override
            public ToDouble<T> orElseGet(ToDouble<T> getter) {
                return object -> delegate.isNull(object) ? getter.applyAsDouble(object) : mapper.applyAsDouble((Enum)delegate.apply(object));
            }

            @Override
            public ToDouble<T> orElse(Double value) {
                return object -> delegate.isNull(object) ? value.doubleValue() : mapper.applyAsDouble((Enum)delegate.apply(object));
            }

            @Override
            public boolean isNull(T object) {
                return delegate.isNull(object);
            }

            @Override
            public boolean isNotNull(T object) {
                return delegate.isNotNull(object);
            }
        };
    }

    @Override
    default public ToEnumNullable<T, E> mapIfPresent(final UnaryOperator<E> mapper) {
        final ToEnumNullable delegate = this;
        return new ToEnumNullable<T, E>(){

            @Override
            public Class<E> enumClass() {
                return delegate.enumClass();
            }

            @Override
            public E apply(T object) {
                return delegate.isNull(object) ? null : (Enum)mapper.apply((Enum)delegate.apply(object));
            }

            @Override
            public ToEnum<T, E> orElseGet(ToEnum<T, E> getter) {
                return new ToEnumImpl<Object, Enum>(delegate.enumClass(), object -> delegate.isNull(object) ? getter.apply(object) : (Enum)mapper.apply((Enum)delegate.apply(object)));
            }

            @Override
            public ToEnum<T, E> orElse(E value) {
                return new ToEnumImpl<Object, Enum>(delegate.enumClass(), object -> delegate.isNull(object) ? value : (Enum)mapper.apply((Enum)delegate.apply(object)));
            }

            @Override
            public boolean isNull(T object) {
                return delegate.isNull(object);
            }

            @Override
            public boolean isNotNull(T object) {
                return delegate.isNotNull(object);
            }
        };
    }

    @Override
    default public long hash(T object) {
        Enum e = (Enum)this.apply(object);
        return e == null ? -1L : (long)e.hashCode();
    }

    @Override
    default public int compare(T first, T second) {
        Enum a = (Enum)this.apply(first);
        Enum b = (Enum)this.apply(second);
        if (a == null) {
            return b == null ? -1 : 0;
        }
        return a.compareTo(b);
    }

    @Override
    default public <V> ToEnumNullable<V, E> compose(Function<? super V, ? extends T> before) {
        Function<? super V, ? extends T> casted = before;
        return ComposedUtil.composeToEnumNullable(casted, this);
    }
}

