/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute;

import com.speedment.runtime.compute.ToByte;
import com.speedment.runtime.compute.ToDouble;
import com.speedment.runtime.compute.ToIntNullable;
import com.speedment.runtime.compute.ToLong;
import com.speedment.runtime.compute.expression.Expression;
import com.speedment.runtime.compute.expression.ExpressionType;
import com.speedment.runtime.compute.expression.Expressions;
import com.speedment.runtime.compute.internal.expression.CastUtil;
import com.speedment.runtime.compute.internal.expression.ComposedUtil;
import com.speedment.runtime.compute.internal.expression.MapperUtil;
import com.speedment.runtime.compute.trait.HasAbs;
import com.speedment.runtime.compute.trait.HasAsDouble;
import com.speedment.runtime.compute.trait.HasAsInt;
import com.speedment.runtime.compute.trait.HasAsLong;
import com.speedment.runtime.compute.trait.HasCompare;
import com.speedment.runtime.compute.trait.HasCompose;
import com.speedment.runtime.compute.trait.HasDivide;
import com.speedment.runtime.compute.trait.HasHash;
import com.speedment.runtime.compute.trait.HasMap;
import com.speedment.runtime.compute.trait.HasMapToDouble;
import com.speedment.runtime.compute.trait.HasMinus;
import com.speedment.runtime.compute.trait.HasMultiply;
import com.speedment.runtime.compute.trait.HasNegate;
import com.speedment.runtime.compute.trait.HasPlus;
import com.speedment.runtime.compute.trait.HasPow;
import com.speedment.runtime.compute.trait.HasSign;
import com.speedment.runtime.compute.trait.HasSqrt;
import java.util.function.Function;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.ToIntFunction;

@FunctionalInterface
public interface ToInt<T>
extends Expression<T>,
ToIntFunction<T>,
HasAsDouble<T>,
HasAsInt<T>,
HasAsLong<T>,
HasAbs<ToInt<T>>,
HasSign<ToByte<T>>,
HasSqrt<ToDouble<T>>,
HasNegate<ToInt<T>>,
HasPow<T>,
HasPlus<T>,
HasMinus<T>,
HasMultiply<T>,
HasDivide<T>,
HasMap<T, IntUnaryOperator, ToInt<T>>,
HasMapToDouble<T, IntToDoubleFunction>,
HasHash<T>,
HasCompare<T>,
HasCompose<T> {
    public static <T> ToInt<T> of(ToIntFunction<T> lambda) {
        if (lambda instanceof ToInt) {
            return (ToInt)lambda;
        }
        return lambda::applyAsInt;
    }

    @Override
    public int applyAsInt(T var1);

    @Override
    default public ExpressionType expressionType() {
        return ExpressionType.INT;
    }

    @Override
    default public ToDouble<T> asDouble() {
        return CastUtil.castIntToDouble(this);
    }

    @Override
    default public ToInt<T> asInt() {
        return this;
    }

    @Override
    default public ToLong<T> asLong() {
        return CastUtil.castIntToLong(this);
    }

    @Override
    default public ToDouble<T> mapToDouble(IntToDoubleFunction operator) {
        return MapperUtil.mapIntToDouble(this, operator);
    }

    @Override
    default public ToInt<T> map(IntUnaryOperator operator) {
        return MapperUtil.mapInt(this, operator);
    }

    @Override
    default public ToInt<T> abs() {
        return Expressions.abs(this);
    }

    @Override
    default public ToByte<T> sign() {
        return Expressions.sign(this);
    }

    @Override
    default public ToDouble<T> sqrt() {
        return Expressions.sqrt(this);
    }

    @Override
    default public ToDouble<T> pow(int power) {
        return Expressions.pow(this, power);
    }

    @Override
    default public ToDouble<T> pow(double power) {
        return Expressions.pow(this, power);
    }

    @Override
    default public ToDouble<T> pow(ToInt<T> power) {
        return Expressions.pow(this, power);
    }

    @Override
    default public ToDouble<T> pow(ToDouble<T> power) {
        return Expressions.pow(this, power);
    }

    @Override
    default public ToInt<T> plus(byte other) {
        return Expressions.plus(this, other);
    }

    @Override
    default public ToInt<T> plus(ToByte<T> other) {
        return Expressions.plus(this, other);
    }

    @Override
    default public ToInt<T> plus(int other) {
        return Expressions.plus(this, other);
    }

    @Override
    default public ToInt<T> plus(ToInt<T> other) {
        return Expressions.plus(this, other);
    }

    @Override
    default public ToLong<T> plus(long other) {
        return Expressions.plus(this, other);
    }

    @Override
    default public ToLong<T> plus(ToLong<T> other) {
        return Expressions.plus(this.asLong(), other);
    }

    @Override
    default public ToDouble<T> plus(double other) {
        return Expressions.plus(this.asDouble(), other);
    }

    @Override
    default public ToDouble<T> plus(ToDouble<T> other) {
        return Expressions.plus(this.asDouble(), other);
    }

    @Override
    default public ToInt<T> minus(byte other) {
        return Expressions.minus(this, other);
    }

    @Override
    default public ToInt<T> minus(ToByte<T> other) {
        return Expressions.minus(this, other);
    }

    @Override
    default public ToInt<T> minus(int other) {
        return Expressions.minus(this, other);
    }

    @Override
    default public ToInt<T> minus(ToInt<T> other) {
        return Expressions.minus(this, other);
    }

    @Override
    default public ToLong<T> minus(long other) {
        return Expressions.minus(this, other);
    }

    @Override
    default public ToLong<T> minus(ToLong<T> other) {
        return Expressions.minus(this.asLong(), other);
    }

    @Override
    default public ToDouble<T> minus(double other) {
        return Expressions.minus(this.asDouble(), other);
    }

    @Override
    default public ToDouble<T> minus(ToDouble<T> other) {
        return Expressions.minus(this.asDouble(), other);
    }

    @Override
    default public ToInt<T> multiply(byte other) {
        return Expressions.multiply(this, other);
    }

    @Override
    default public ToInt<T> multiply(ToByte<T> other) {
        return Expressions.multiply(this, other.asInt());
    }

    @Override
    default public ToInt<T> multiply(int other) {
        return Expressions.multiply(this, other);
    }

    @Override
    default public ToInt<T> multiply(ToInt<T> other) {
        return Expressions.multiply(this, other);
    }

    @Override
    default public ToLong<T> multiply(long other) {
        return Expressions.multiply(this, other);
    }

    @Override
    default public ToLong<T> multiply(ToLong<T> other) {
        return Expressions.multiply(this.asLong(), other);
    }

    @Override
    default public ToDouble<T> multiply(double other) {
        return Expressions.multiply(this.asDouble(), other);
    }

    @Override
    default public ToDouble<T> multiply(ToDouble<T> other) {
        return Expressions.multiply(this.asDouble(), other);
    }

    @Override
    default public ToDouble<T> divide(int divisor) {
        return Expressions.divide(this, divisor);
    }

    @Override
    default public ToDouble<T> divide(ToInt<T> divisor) {
        return Expressions.divide(this, divisor);
    }

    @Override
    default public ToDouble<T> divide(long divisor) {
        return Expressions.divide(this, divisor);
    }

    @Override
    default public ToDouble<T> divide(ToLong<T> divisor) {
        return Expressions.divide(this, divisor);
    }

    @Override
    default public ToDouble<T> divide(double divisor) {
        return Expressions.divide(this, divisor);
    }

    @Override
    default public ToDouble<T> divide(ToDouble<T> divisor) {
        return Expressions.divide(this, divisor);
    }

    @Override
    default public ToInt<T> negate() {
        return Expressions.negate(this);
    }

    @Override
    default public long hash(T object) {
        return this.applyAsInt(object);
    }

    @Override
    default public int compare(T first, T second) {
        return Integer.compare(this.applyAsInt(first), this.applyAsInt(second));
    }

    @Override
    default public <V> ToIntNullable<V> compose(Function<? super V, ? extends T> before) {
        Function<? super V, ? extends T> casted = before;
        return ComposedUtil.composeToInt(casted, this);
    }
}

