/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute.expression;

import com.speedment.runtime.compute.ToBigDecimal;
import com.speedment.runtime.compute.ToBoolean;
import com.speedment.runtime.compute.ToBooleanNullable;
import com.speedment.runtime.compute.ToByte;
import com.speedment.runtime.compute.ToByteNullable;
import com.speedment.runtime.compute.ToDouble;
import com.speedment.runtime.compute.ToDoubleNullable;
import com.speedment.runtime.compute.ToFloat;
import com.speedment.runtime.compute.ToFloatNullable;
import com.speedment.runtime.compute.ToInt;
import com.speedment.runtime.compute.ToIntNullable;
import com.speedment.runtime.compute.ToLong;
import com.speedment.runtime.compute.ToLongNullable;
import com.speedment.runtime.compute.ToShort;
import com.speedment.runtime.compute.ToShortNullable;
import com.speedment.runtime.compute.ToString;
import com.speedment.runtime.compute.internal.BinaryJoiningExpressionImpl;
import com.speedment.runtime.compute.internal.JoiningExpressionImpl;
import com.speedment.runtime.compute.internal.ToByteNullableImpl;
import com.speedment.runtime.compute.internal.ToDoubleNullableImpl;
import com.speedment.runtime.compute.internal.expression.AbsUtil;
import com.speedment.runtime.compute.internal.expression.DivideUtil;
import com.speedment.runtime.compute.internal.expression.MinusUtil;
import com.speedment.runtime.compute.internal.expression.MultiplyUtil;
import com.speedment.runtime.compute.internal.expression.NegateUtil;
import com.speedment.runtime.compute.internal.expression.PlusUtil;
import com.speedment.runtime.compute.internal.expression.PowUtil;
import com.speedment.runtime.compute.internal.expression.SignUtil;
import com.speedment.runtime.compute.internal.expression.SqrtUtil;
import java.util.Arrays;

public final class Expressions {
    private Expressions() {
        throw new UnsupportedOperationException();
    }

    public static <T> ToDouble<T> byteToDouble(ToByte<T> expression) {
        return expression.asDouble();
    }

    public static <T> ToDouble<T> shortToDouble(ToShort<T> expression) {
        return expression.asDouble();
    }

    public static <T> ToDouble<T> intToDouble(ToInt<T> expression) {
        return expression.asDouble();
    }

    public static <T> ToDouble<T> longToDouble(ToLong<T> expression) {
        return expression.asDouble();
    }

    public static <T> ToDouble<T> floatToDouble(ToFloat<T> expression) {
        return expression.asDouble();
    }

    public static <T> ToDoubleNullable<T> byteToDoubleNullable(ToByteNullable<T> expression) {
        return expression.mapToDoubleIfPresent(b -> b);
    }

    public static <T> ToDoubleNullable<T> shortToDoubleNullable(ToShortNullable<T> expression) {
        return expression.mapToDoubleIfPresent(b -> b);
    }

    public static <T> ToDoubleNullable<T> intToDoubleNullable(ToIntNullable<T> expression) {
        return expression.mapToDoubleIfPresent(b -> b);
    }

    public static <T> ToDoubleNullable<T> longToDoubleNullable(ToLongNullable<T> expression) {
        return expression.mapToDoubleIfPresent(b -> b);
    }

    public static <T> ToDoubleNullable<T> floatToDoubleNullable(ToFloatNullable<T> expression) {
        return expression.mapToDoubleIfPresent(b -> b);
    }

    public static <T> ToByte<T> abs(ToByte<T> expression) {
        return AbsUtil.absByte(expression);
    }

    public static <T> ToShort<T> abs(ToShort<T> expression) {
        return AbsUtil.absShort(expression);
    }

    public static <T> ToInt<T> abs(ToInt<T> expression) {
        return AbsUtil.absInt(expression);
    }

    public static <T> ToLong<T> abs(ToLong<T> expression) {
        return AbsUtil.absLong(expression);
    }

    public static <T> ToFloat<T> abs(ToFloat<T> expression) {
        return AbsUtil.absFloat(expression);
    }

    public static <T> ToDouble<T> abs(ToDouble<T> expression) {
        return AbsUtil.absDouble(expression);
    }

    public static <T> ToByteNullable<T> absOrNull(ToByteNullable<T> expression) {
        return AbsUtil.absByteOrNull(expression);
    }

    public static <T> ToShortNullable<T> absOrNull(ToShortNullable<T> expression) {
        return AbsUtil.absShortOrNull(expression);
    }

    public static <T> ToIntNullable<T> absOrNull(ToIntNullable<T> expression) {
        return AbsUtil.absIntOrNull(expression);
    }

    public static <T> ToLongNullable<T> absOrNull(ToLongNullable<T> expression) {
        return AbsUtil.absLongOrNull(expression);
    }

    public static <T> ToFloatNullable<T> absOrNull(ToFloatNullable<T> expression) {
        return AbsUtil.absFloatOrNull(expression);
    }

    public static <T> ToDoubleNullable<T> absOrNull(ToDoubleNullable<T> expression) {
        return AbsUtil.absDoubleOrNull(expression);
    }

    public static <T> ToByte<T> sign(ToByte<T> expression) {
        return SignUtil.signByte(expression);
    }

    public static <T> ToByte<T> sign(ToShort<T> expression) {
        return SignUtil.signShort(expression);
    }

    public static <T> ToByte<T> sign(ToInt<T> expression) {
        return SignUtil.signInt(expression);
    }

    public static <T> ToByte<T> sign(ToLong<T> expression) {
        return SignUtil.signLong(expression);
    }

    public static <T> ToByte<T> sign(ToFloat<T> expression) {
        return SignUtil.signFloat(expression);
    }

    public static <T> ToByte<T> sign(ToDouble<T> expression) {
        return SignUtil.signDouble(expression);
    }

    public static <T> ToByte<T> sign(ToBigDecimal<T> expression) {
        return SignUtil.signBigDecimal(expression);
    }

    public static <T> ToByteNullable<T> signOrNull(ToByteNullable<T> expression) {
        return new ToByteNullableImpl(SignUtil.signByte(expression.orThrow()), expression.isNull());
    }

    public static <T> ToByteNullable<T> signOrNull(ToShortNullable<T> expression) {
        return new ToByteNullableImpl(SignUtil.signShort(expression.orThrow()), expression.isNull());
    }

    public static <T> ToByteNullable<T> signOrNull(ToIntNullable<T> expression) {
        return new ToByteNullableImpl(SignUtil.signInt(expression.orThrow()), expression.isNull());
    }

    public static <T> ToByteNullable<T> signOrNull(ToLongNullable<T> expression) {
        return new ToByteNullableImpl(SignUtil.signLong(expression.orThrow()), expression.isNull());
    }

    public static <T> ToByteNullable<T> signOrNull(ToFloatNullable<T> expression) {
        return new ToByteNullableImpl(SignUtil.signFloat(expression.orThrow()), expression.isNull());
    }

    public static <T> ToByteNullable<T> signOrNull(ToDoubleNullable<T> expression) {
        return new ToByteNullableImpl(SignUtil.signDouble(expression.orThrow()), expression.isNull());
    }

    public static <T> ToDouble<T> sqrt(ToByte<T> expression) {
        return SqrtUtil.sqrtByte(expression);
    }

    public static <T> ToDouble<T> sqrt(ToShort<T> expression) {
        return SqrtUtil.sqrtShort(expression);
    }

    public static <T> ToDouble<T> sqrt(ToInt<T> expression) {
        return SqrtUtil.sqrtInt(expression);
    }

    public static <T> ToDouble<T> sqrt(ToLong<T> expression) {
        return SqrtUtil.sqrtLong(expression);
    }

    public static <T> ToDouble<T> sqrt(ToFloat<T> expression) {
        return SqrtUtil.sqrtFloat(expression);
    }

    public static <T> ToDouble<T> sqrt(ToDouble<T> expression) {
        return SqrtUtil.sqrtDouble(expression);
    }

    public static <T> ToDoubleNullable<T> sqrtOrNull(ToByteNullable<T> expression) {
        return new ToDoubleNullableImpl(SqrtUtil.sqrtByte(expression.orThrow()), expression.isNull());
    }

    public static <T> ToDoubleNullable<T> sqrtOrNull(ToShortNullable<T> expression) {
        return new ToDoubleNullableImpl(SqrtUtil.sqrtShort(expression.orThrow()), expression.isNull());
    }

    public static <T> ToDoubleNullable<T> sqrtOrNull(ToIntNullable<T> expression) {
        return new ToDoubleNullableImpl(SqrtUtil.sqrtInt(expression.orThrow()), expression.isNull());
    }

    public static <T> ToDoubleNullable<T> sqrtOrNull(ToLongNullable<T> expression) {
        return new ToDoubleNullableImpl(SqrtUtil.sqrtLong(expression.orThrow()), expression.isNull());
    }

    public static <T> ToDoubleNullable<T> sqrtOrNull(ToFloatNullable<T> expression) {
        return new ToDoubleNullableImpl(SqrtUtil.sqrtFloat(expression.orThrow()), expression.isNull());
    }

    public static <T> ToDoubleNullable<T> sqrtOrNull(ToDoubleNullable<T> expression) {
        return new ToDoubleNullableImpl(SqrtUtil.sqrtDouble(expression.orThrow()), expression.isNull());
    }

    public static <T> ToDouble<T> pow(ToByte<T> expression, int power) {
        return PowUtil.bytePowInt(expression, power);
    }

    public static <T> ToDouble<T> pow(ToByte<T> expression, double power) {
        return PowUtil.bytePowDouble(expression, power);
    }

    public static <T> ToDouble<T> pow(ToByte<T> expression, ToInt<T> power) {
        return PowUtil.bytePowInt(expression, power);
    }

    public static <T> ToDouble<T> pow(ToByte<T> expression, ToDouble<T> power) {
        return PowUtil.bytePowDouble(expression, power);
    }

    public static <T> ToDoubleNullable<T> powOrNull(ToByteNullable<T> expression, int power) {
        return new ToDoubleNullableImpl(PowUtil.bytePowInt(expression.orThrow(), power), expression.isNull());
    }

    public static <T> ToDoubleNullable<T> powOrNull(ToByteNullable<T> expression, double power) {
        return new ToDoubleNullableImpl(PowUtil.bytePowDouble(expression.orThrow(), power), expression.isNull());
    }

    public static <T> ToDoubleNullable<T> powOrNull(ToByteNullable<T> expression, ToInt<T> power) {
        return new ToDoubleNullableImpl<T>(PowUtil.bytePowInt(expression.orThrow(), power), expression.isNull());
    }

    public static <T> ToDoubleNullable<T> powOrNull(ToByteNullable<T> expression, ToDouble<T> power) {
        return new ToDoubleNullableImpl<T>(PowUtil.bytePowDouble(expression.orThrow(), power), expression.isNull());
    }

    public static <T> ToDouble<T> pow(ToShort<T> expression, int power) {
        return PowUtil.shortPowInt(expression, power);
    }

    public static <T> ToDouble<T> pow(ToShort<T> expression, double power) {
        return PowUtil.shortPowDouble(expression, power);
    }

    public static <T> ToDouble<T> pow(ToShort<T> expression, ToInt<T> power) {
        return PowUtil.shortPowInt(expression, power);
    }

    public static <T> ToDouble<T> pow(ToShort<T> expression, ToDouble<T> power) {
        return PowUtil.shortPowDouble(expression, power);
    }

    public static <T> ToDoubleNullable<T> powOrNull(ToShortNullable<T> expression, int power) {
        return new ToDoubleNullableImpl(PowUtil.shortPowInt(expression.orThrow(), power), expression.isNull());
    }

    public static <T> ToDoubleNullable<T> powOrNull(ToShortNullable<T> expression, double power) {
        return new ToDoubleNullableImpl(PowUtil.shortPowDouble(expression.orThrow(), power), expression.isNull());
    }

    public static <T> ToDoubleNullable<T> powOrNull(ToShortNullable<T> expression, ToInt<T> power) {
        return new ToDoubleNullableImpl<T>(PowUtil.shortPowInt(expression.orThrow(), power), expression.isNull());
    }

    public static <T> ToDoubleNullable<T> powOrNull(ToShortNullable<T> expression, ToDouble<T> power) {
        return new ToDoubleNullableImpl<T>(PowUtil.shortPowDouble(expression.orThrow(), power), expression.isNull());
    }

    public static <T> ToDouble<T> pow(ToInt<T> expression, int power) {
        return PowUtil.intPowInt(expression, power);
    }

    public static <T> ToDouble<T> pow(ToInt<T> expression, double power) {
        return PowUtil.intPowDouble(expression, power);
    }

    public static <T> ToDouble<T> pow(ToInt<T> expression, ToInt<T> power) {
        return PowUtil.intPowInt(expression, power);
    }

    public static <T> ToDouble<T> pow(ToInt<T> expression, ToDouble<T> power) {
        return PowUtil.intPowDouble(expression, power);
    }

    public static <T> ToDoubleNullable<T> powOrNull(ToIntNullable<T> expression, int power) {
        return new ToDoubleNullableImpl(PowUtil.intPowInt(expression.orThrow(), power), expression.isNull());
    }

    public static <T> ToDoubleNullable<T> powOrNull(ToIntNullable<T> expression, double power) {
        return new ToDoubleNullableImpl(PowUtil.intPowDouble(expression.orThrow(), power), expression.isNull());
    }

    public static <T> ToDoubleNullable<T> powOrNull(ToIntNullable<T> expression, ToInt<T> power) {
        return new ToDoubleNullableImpl<T>(PowUtil.intPowInt(expression.orThrow(), power), expression.isNull());
    }

    public static <T> ToDoubleNullable<T> powOrNull(ToIntNullable<T> expression, ToDouble<T> power) {
        return new ToDoubleNullableImpl<T>(PowUtil.intPowDouble(expression.orThrow(), power), expression.isNull());
    }

    public static <T> ToDouble<T> pow(ToLong<T> expression, int power) {
        return PowUtil.longPowInt(expression, power);
    }

    public static <T> ToDouble<T> pow(ToLong<T> expression, double power) {
        return PowUtil.longPowDouble(expression, power);
    }

    public static <T> ToDouble<T> pow(ToLong<T> expression, ToInt<T> power) {
        return PowUtil.longPowInt(expression, power);
    }

    public static <T> ToDouble<T> pow(ToLong<T> expression, ToDouble<T> power) {
        return PowUtil.longPowDouble(expression, power);
    }

    public static <T> ToDoubleNullable<T> powOrNull(ToLongNullable<T> expression, int power) {
        return new ToDoubleNullableImpl(PowUtil.longPowInt(expression.orThrow(), power), expression.isNull());
    }

    public static <T> ToDoubleNullable<T> powOrNull(ToLongNullable<T> expression, double power) {
        return new ToDoubleNullableImpl(PowUtil.longPowDouble(expression.orThrow(), power), expression.isNull());
    }

    public static <T> ToDoubleNullable<T> powOrNull(ToLongNullable<T> expression, ToInt<T> power) {
        return new ToDoubleNullableImpl<T>(PowUtil.longPowInt(expression.orThrow(), power), expression.isNull());
    }

    public static <T> ToDoubleNullable<T> powOrNull(ToLongNullable<T> expression, ToDouble<T> power) {
        return new ToDoubleNullableImpl<T>(PowUtil.longPowDouble(expression.orThrow(), power), expression.isNull());
    }

    public static <T> ToDouble<T> pow(ToFloat<T> expression, int power) {
        return PowUtil.floatPowInt(expression, power);
    }

    public static <T> ToDouble<T> pow(ToFloat<T> expression, double power) {
        return PowUtil.floatPowDouble(expression, power);
    }

    public static <T> ToDouble<T> pow(ToFloat<T> expression, ToInt<T> power) {
        return PowUtil.floatPowInt(expression, power);
    }

    public static <T> ToDouble<T> pow(ToFloat<T> expression, ToDouble<T> power) {
        return PowUtil.floatPowDouble(expression, power);
    }

    public static <T> ToDoubleNullable<T> powOrNull(ToFloatNullable<T> expression, int power) {
        return new ToDoubleNullableImpl(PowUtil.floatPowInt(expression.orThrow(), power), expression.isNull());
    }

    public static <T> ToDoubleNullable<T> powOrNull(ToFloatNullable<T> expression, double power) {
        return new ToDoubleNullableImpl(PowUtil.floatPowDouble(expression.orThrow(), power), expression.isNull());
    }

    public static <T> ToDoubleNullable<T> powOrNull(ToFloatNullable<T> expression, ToInt<T> power) {
        return new ToDoubleNullableImpl<T>(PowUtil.floatPowInt(expression.orThrow(), power), expression.isNull());
    }

    public static <T> ToDoubleNullable<T> powOrNull(ToFloatNullable<T> expression, ToDouble<T> power) {
        return new ToDoubleNullableImpl<T>(PowUtil.floatPowDouble(expression.orThrow(), power), expression.isNull());
    }

    public static <T> ToDouble<T> pow(ToDouble<T> expression, int power) {
        return PowUtil.doublePowInt(expression, power);
    }

    public static <T> ToDouble<T> pow(ToDouble<T> expression, double power) {
        return PowUtil.doublePowDouble(expression, power);
    }

    public static <T> ToDouble<T> pow(ToDouble<T> expression, ToInt<T> power) {
        return PowUtil.doublePowInt(expression, power);
    }

    public static <T> ToDouble<T> pow(ToDouble<T> expression, ToDouble<T> power) {
        return PowUtil.doublePowDouble(expression, power);
    }

    public static <T> ToDoubleNullable<T> powOrNull(ToDoubleNullable<T> expression, int power) {
        return new ToDoubleNullableImpl(PowUtil.doublePowInt(expression.orThrow(), power), expression.isNull());
    }

    public static <T> ToDoubleNullable<T> powOrNull(ToDoubleNullable<T> expression, double power) {
        return new ToDoubleNullableImpl(PowUtil.doublePowDouble(expression.orThrow(), power), expression.isNull());
    }

    public static <T> ToDoubleNullable<T> powOrNull(ToDoubleNullable<T> expression, ToInt<T> power) {
        return new ToDoubleNullableImpl<T>(PowUtil.doublePowInt(expression.orThrow(), power), expression.isNull());
    }

    public static <T> ToDoubleNullable<T> powOrNull(ToDoubleNullable<T> expression, ToDouble<T> power) {
        return new ToDoubleNullableImpl<T>(PowUtil.doublePowDouble(expression.orThrow(), power), expression.isNull());
    }

    public static <T> ToByte<T> negate(ToByte<T> expression) {
        return NegateUtil.negateByte(expression);
    }

    public static <T> ToShort<T> negate(ToShort<T> expression) {
        return NegateUtil.negateShort(expression);
    }

    public static <T> ToInt<T> negate(ToInt<T> expression) {
        return NegateUtil.negateInt(expression);
    }

    public static <T> ToLong<T> negate(ToLong<T> expression) {
        return NegateUtil.negateLong(expression);
    }

    public static <T> ToFloat<T> negate(ToFloat<T> expression) {
        return NegateUtil.negateFloat(expression);
    }

    public static <T> ToDouble<T> negate(ToDouble<T> expression) {
        return NegateUtil.negateDouble(expression);
    }

    public static <T> ToBigDecimal<T> negate(ToBigDecimal<T> expression) {
        return NegateUtil.negateBigDecimal(expression);
    }

    public static <T> ToBoolean<T> negate(ToBoolean<T> expression) {
        return NegateUtil.negateBoolean(expression);
    }

    public static <T> ToByteNullable<T> negateOrNull(ToByteNullable<T> expression) {
        return NegateUtil.negateByteOrNull(expression);
    }

    public static <T> ToShortNullable<T> negateOrNull(ToShortNullable<T> expression) {
        return NegateUtil.negateShortOrNull(expression);
    }

    public static <T> ToIntNullable<T> negateOrNull(ToIntNullable<T> expression) {
        return NegateUtil.negateIntOrNull(expression);
    }

    public static <T> ToLongNullable<T> negateOrNull(ToLongNullable<T> expression) {
        return NegateUtil.negateLongOrNull(expression);
    }

    public static <T> ToFloatNullable<T> negateOrNull(ToFloatNullable<T> expression) {
        return NegateUtil.negateFloatOrNull(expression);
    }

    public static <T> ToDoubleNullable<T> negateOrNull(ToDoubleNullable<T> expression) {
        return NegateUtil.negateDoubleOrNull(expression);
    }

    public static <T> ToBooleanNullable<T> negateOrNull(ToBooleanNullable<T> expression) {
        return NegateUtil.negateBooleanOrNull(expression);
    }

    public static <T> ToShort<T> plus(ToByte<T> first, byte second) {
        return PlusUtil.bytePlusByte(first, second);
    }

    public static <T> ToInt<T> plus(ToByte<T> first, int second) {
        return PlusUtil.bytePlusInt(first, second);
    }

    public static <T> ToLong<T> plus(ToByte<T> first, long second) {
        return PlusUtil.bytePlusLong(first, second);
    }

    public static <T> ToShort<T> plus(ToByte<T> first, ToByte<T> second) {
        return PlusUtil.bytePlusByte(first, second);
    }

    public static <T> ToInt<T> plus(ToShort<T> first, byte second) {
        return PlusUtil.shortPlusByte(first, second);
    }

    public static <T> ToInt<T> plus(ToShort<T> first, int second) {
        return PlusUtil.shortPlusInt(first, second);
    }

    public static <T> ToLong<T> plus(ToShort<T> first, long second) {
        return PlusUtil.shortPlusLong(first, second);
    }

    public static <T> ToShort<T> plus(ToShort<T> first, ToShort<T> second) {
        return PlusUtil.shortPlusShort(first, second);
    }

    public static <T> ToInt<T> plus(ToInt<T> first, byte second) {
        return PlusUtil.intPlusByte(first, second);
    }

    public static <T> ToInt<T> plus(ToInt<T> first, int second) {
        return PlusUtil.intPlusInt(first, second);
    }

    public static <T> ToLong<T> plus(ToInt<T> first, long second) {
        return PlusUtil.intPlusLong(first, second);
    }

    public static <T> ToInt<T> plus(ToInt<T> first, ToByte<T> second) {
        return PlusUtil.intPlusByte(first, second);
    }

    public static <T> ToInt<T> plus(ToInt<T> first, ToInt<T> second) {
        return PlusUtil.intPlusInt(first, second);
    }

    public static <T> ToLong<T> plus(ToLong<T> first, byte second) {
        return PlusUtil.longPlusByte(first, second);
    }

    public static <T> ToLong<T> plus(ToLong<T> first, int second) {
        return PlusUtil.longPlusInt(first, second);
    }

    public static <T> ToLong<T> plus(ToLong<T> first, long second) {
        return PlusUtil.longPlusLong(first, second);
    }

    public static <T> ToLong<T> plus(ToLong<T> first, ToInt<T> second) {
        return PlusUtil.longPlusInt(first, second);
    }

    public static <T> ToLong<T> plus(ToLong<T> first, ToLong<T> second) {
        return PlusUtil.longPlusLong(first, second);
    }

    public static <T> ToFloat<T> plus(ToFloat<T> first, int second) {
        return PlusUtil.floatPlusInt(first, second);
    }

    public static <T> ToDouble<T> plus(ToFloat<T> first, long second) {
        return PlusUtil.floatPlusLong(first, second);
    }

    public static <T> ToFloat<T> plus(ToFloat<T> first, float second) {
        return PlusUtil.floatPlusFloat(first, second);
    }

    public static <T> ToFloat<T> plus(ToFloat<T> first, ToInt<T> second) {
        return PlusUtil.floatPlusInt(first, second);
    }

    public static <T> ToDouble<T> plus(ToFloat<T> first, ToLong<T> second) {
        return PlusUtil.floatPlusLong(first, second);
    }

    public static <T> ToFloat<T> plus(ToFloat<T> first, ToFloat<T> second) {
        return PlusUtil.floatPlusFloat(first, second);
    }

    public static <T> ToDouble<T> plus(ToDouble<T> first, int second) {
        return PlusUtil.doublePlusInt(first, second);
    }

    public static <T> ToDouble<T> plus(ToDouble<T> first, long second) {
        return PlusUtil.doublePlusLong(first, second);
    }

    public static <T> ToDouble<T> plus(ToDouble<T> first, double second) {
        return PlusUtil.doublePlusDouble(first, second);
    }

    public static <T> ToDouble<T> plus(ToDouble<T> first, ToInt<T> second) {
        return PlusUtil.doublePlusInt(first, second);
    }

    public static <T> ToDouble<T> plus(ToDouble<T> first, ToLong<T> second) {
        return PlusUtil.doublePlusLong(first, second);
    }

    public static <T> ToDouble<T> plus(ToDouble<T> first, ToDouble<T> second) {
        return PlusUtil.doublePlusDouble(first, second);
    }

    public static <T> ToShort<T> minus(ToByte<T> first, byte second) {
        return MinusUtil.byteMinusByte(first, second);
    }

    public static <T> ToInt<T> minus(ToByte<T> first, int second) {
        return MinusUtil.byteMinusInt(first, second);
    }

    public static <T> ToLong<T> minus(ToByte<T> first, long second) {
        return MinusUtil.byteMinusLong(first, second);
    }

    public static <T> ToShort<T> minus(ToByte<T> first, ToByte<T> second) {
        return MinusUtil.byteMinusByte(first, second);
    }

    public static <T> ToInt<T> minus(ToShort<T> first, byte second) {
        return MinusUtil.shortMinusByte(first, second);
    }

    public static <T> ToInt<T> minus(ToShort<T> first, int second) {
        return MinusUtil.shortMinusInt(first, second);
    }

    public static <T> ToLong<T> minus(ToShort<T> first, long second) {
        return MinusUtil.shortMinusLong(first, second);
    }

    public static <T> ToShort<T> minus(ToShort<T> first, ToShort<T> second) {
        return MinusUtil.shortMinusShort(first, second);
    }

    public static <T> ToInt<T> minus(ToInt<T> first, byte second) {
        return MinusUtil.intMinusByte(first, second);
    }

    public static <T> ToInt<T> minus(ToInt<T> first, int second) {
        return MinusUtil.intMinusInt(first, second);
    }

    public static <T> ToLong<T> minus(ToInt<T> first, long second) {
        return MinusUtil.intMinusLong(first, second);
    }

    public static <T> ToInt<T> minus(ToInt<T> first, ToByte<T> second) {
        return MinusUtil.intMinusByte(first, second);
    }

    public static <T> ToInt<T> minus(ToInt<T> first, ToInt<T> second) {
        return MinusUtil.intMinusInt(first, second);
    }

    public static <T> ToLong<T> minus(ToLong<T> first, byte second) {
        return MinusUtil.longMinusByte(first, second);
    }

    public static <T> ToLong<T> minus(ToLong<T> first, int second) {
        return MinusUtil.longMinusInt(first, second);
    }

    public static <T> ToLong<T> minus(ToLong<T> first, long second) {
        return MinusUtil.longMinusLong(first, second);
    }

    public static <T> ToLong<T> minus(ToLong<T> first, ToInt<T> second) {
        return MinusUtil.longMinusInt(first, second);
    }

    public static <T> ToLong<T> minus(ToLong<T> first, ToLong<T> second) {
        return MinusUtil.longMinusLong(first, second);
    }

    public static <T> ToFloat<T> minus(ToFloat<T> first, int second) {
        return MinusUtil.floatMinusInt(first, second);
    }

    public static <T> ToDouble<T> minus(ToFloat<T> first, long second) {
        return MinusUtil.floatMinusLong(first, second);
    }

    public static <T> ToFloat<T> minus(ToFloat<T> first, float second) {
        return MinusUtil.floatMinusFloat(first, second);
    }

    public static <T> ToFloat<T> minus(ToFloat<T> first, ToInt<T> second) {
        return MinusUtil.floatMinusInt(first, second);
    }

    public static <T> ToDouble<T> minus(ToFloat<T> first, ToLong<T> second) {
        return MinusUtil.floatMinusLong(first, second);
    }

    public static <T> ToFloat<T> minus(ToFloat<T> first, ToFloat<T> second) {
        return MinusUtil.floatMinusFloat(first, second);
    }

    public static <T> ToDouble<T> minus(ToDouble<T> first, int second) {
        return MinusUtil.doubleMinusInt(first, second);
    }

    public static <T> ToDouble<T> minus(ToDouble<T> first, long second) {
        return MinusUtil.doubleMinusLong(first, second);
    }

    public static <T> ToDouble<T> minus(ToDouble<T> first, double second) {
        return MinusUtil.doubleMinusDouble(first, second);
    }

    public static <T> ToDouble<T> minus(ToDouble<T> first, ToInt<T> second) {
        return MinusUtil.doubleMinusInt(first, second);
    }

    public static <T> ToDouble<T> minus(ToDouble<T> first, ToLong<T> second) {
        return MinusUtil.doubleMinusLong(first, second);
    }

    public static <T> ToDouble<T> minus(ToDouble<T> first, ToDouble<T> second) {
        return MinusUtil.doubleMinusDouble(first, second);
    }

    public static <T> ToInt<T> multiply(ToByte<T> first, byte second) {
        return MultiplyUtil.byteMultiplyByte(first, second);
    }

    public static <T> ToInt<T> multiply(ToByte<T> first, int second) {
        return MultiplyUtil.byteMultiplyInt(first, second);
    }

    public static <T> ToLong<T> multiply(ToByte<T> first, long second) {
        return MultiplyUtil.byteMultiplyLong(first, second);
    }

    public static <T> ToInt<T> multiply(ToByte<T> first, ToByte<T> second) {
        return MultiplyUtil.byteMultiplyByte(first, second);
    }

    public static <T> ToInt<T> multiply(ToShort<T> first, byte second) {
        return MultiplyUtil.shortMultiplyByte(first, second);
    }

    public static <T> ToInt<T> multiply(ToShort<T> first, int second) {
        return MultiplyUtil.shortMultiplyInt(first, second);
    }

    public static <T> ToLong<T> multiply(ToShort<T> first, long second) {
        return MultiplyUtil.shortMultiplyLong(first, second);
    }

    public static <T> ToInt<T> multiply(ToShort<T> first, ToShort<T> second) {
        return MultiplyUtil.shortMultiplyShort(first, second);
    }

    public static <T> ToInt<T> multiply(ToInt<T> first, byte second) {
        return MultiplyUtil.intMultiplyByte(first, second);
    }

    public static <T> ToInt<T> multiply(ToInt<T> first, int second) {
        return MultiplyUtil.intMultiplyInt(first, second);
    }

    public static <T> ToLong<T> multiply(ToInt<T> first, long second) {
        return MultiplyUtil.intMultiplyLong(first, second);
    }

    public static <T> ToInt<T> multiply(ToInt<T> first, ToByte<T> second) {
        return MultiplyUtil.intMultiplyByte(first, second);
    }

    public static <T> ToInt<T> multiply(ToInt<T> first, ToInt<T> second) {
        return MultiplyUtil.intMultiplyInt(first, second);
    }

    public static <T> ToLong<T> multiply(ToLong<T> first, byte second) {
        return MultiplyUtil.longMultiplyByte(first, second);
    }

    public static <T> ToLong<T> multiply(ToLong<T> first, int second) {
        return MultiplyUtil.longMultiplyInt(first, second);
    }

    public static <T> ToLong<T> multiply(ToLong<T> first, long second) {
        return MultiplyUtil.longMultiplyLong(first, second);
    }

    public static <T> ToLong<T> multiply(ToLong<T> first, ToInt<T> second) {
        return MultiplyUtil.longMultiplyInt(first, second);
    }

    public static <T> ToLong<T> multiply(ToLong<T> first, ToLong<T> second) {
        return MultiplyUtil.longMultiplyLong(first, second);
    }

    public static <T> ToFloat<T> multiply(ToFloat<T> first, int second) {
        return MultiplyUtil.floatMultiplyInt(first, second);
    }

    public static <T> ToDouble<T> multiply(ToFloat<T> first, long second) {
        return MultiplyUtil.floatMultiplyLong(first, second);
    }

    public static <T> ToFloat<T> multiply(ToFloat<T> first, float second) {
        return MultiplyUtil.floatMultiplyFloat(first, second);
    }

    public static <T> ToFloat<T> multiply(ToFloat<T> first, ToInt<T> second) {
        return MultiplyUtil.floatMultiplyInt(first, second);
    }

    public static <T> ToDouble<T> multiply(ToFloat<T> first, ToLong<T> second) {
        return MultiplyUtil.floatMultiplyLong(first, second);
    }

    public static <T> ToFloat<T> multiply(ToFloat<T> first, ToFloat<T> second) {
        return MultiplyUtil.floatMultiplyFloat(first, second);
    }

    public static <T> ToDouble<T> multiply(ToDouble<T> first, int second) {
        return MultiplyUtil.doubleMultiplyInt(first, second);
    }

    public static <T> ToDouble<T> multiply(ToDouble<T> first, long second) {
        return MultiplyUtil.doubleMultiplyLong(first, second);
    }

    public static <T> ToDouble<T> multiply(ToDouble<T> first, double second) {
        return MultiplyUtil.doubleMultiplyDouble(first, second);
    }

    public static <T> ToDouble<T> multiply(ToDouble<T> first, ToInt<T> second) {
        return MultiplyUtil.doubleMultiplyInt(first, second);
    }

    public static <T> ToDouble<T> multiply(ToDouble<T> first, ToLong<T> second) {
        return MultiplyUtil.doubleMultiplyLong(first, second);
    }

    public static <T> ToDouble<T> multiply(ToDouble<T> first, ToDouble<T> second) {
        return MultiplyUtil.doubleMultiplyDouble(first, second);
    }

    public static <T> ToDouble<T> divide(ToByte<T> first, int second) {
        return DivideUtil.byteDivideInt(first, second);
    }

    public static <T> ToDouble<T> divide(ToByte<T> first, long second) {
        return DivideUtil.byteDivideLong(first, second);
    }

    public static <T> ToDouble<T> divide(ToByte<T> first, double second) {
        return DivideUtil.byteDivideDouble(first, second);
    }

    public static <T> ToDouble<T> divide(ToByte<T> first, ToInt<T> second) {
        return DivideUtil.byteDivideInt(first, second);
    }

    public static <T> ToDouble<T> divide(ToByte<T> first, ToLong<T> second) {
        return DivideUtil.byteDivideLong(first, second);
    }

    public static <T> ToDouble<T> divide(ToByte<T> first, ToDouble<T> second) {
        return DivideUtil.byteDivideDouble(first, second);
    }

    public static <T> ToDouble<T> divide(ToShort<T> first, int second) {
        return DivideUtil.shortDivideInt(first, second);
    }

    public static <T> ToDouble<T> divide(ToShort<T> first, long second) {
        return DivideUtil.shortDivideLong(first, second);
    }

    public static <T> ToDouble<T> divide(ToShort<T> first, double second) {
        return DivideUtil.shortDivideDouble(first, second);
    }

    public static <T> ToDouble<T> divide(ToShort<T> first, ToInt<T> second) {
        return DivideUtil.shortDivideInt(first, second);
    }

    public static <T> ToDouble<T> divide(ToShort<T> first, ToLong<T> second) {
        return DivideUtil.shortDivideLong(first, second);
    }

    public static <T> ToDouble<T> divide(ToShort<T> first, ToDouble<T> second) {
        return DivideUtil.shortDivideDouble(first, second);
    }

    public static <T> ToDouble<T> divide(ToInt<T> first, int second) {
        return DivideUtil.intDivideInt(first, second);
    }

    public static <T> ToDouble<T> divide(ToInt<T> first, long second) {
        return DivideUtil.intDivideLong(first, second);
    }

    public static <T> ToDouble<T> divide(ToInt<T> first, double second) {
        return DivideUtil.intDivideDouble(first, second);
    }

    public static <T> ToDouble<T> divide(ToInt<T> first, ToInt<T> second) {
        return DivideUtil.intDivideInt(first, second);
    }

    public static <T> ToDouble<T> divide(ToInt<T> first, ToLong<T> second) {
        return DivideUtil.intDivideLong(first, second);
    }

    public static <T> ToDouble<T> divide(ToInt<T> first, ToDouble<T> second) {
        return DivideUtil.intDivideDouble(first, second);
    }

    public static <T> ToDouble<T> divide(ToLong<T> first, int second) {
        return DivideUtil.longDivideInt(first, second);
    }

    public static <T> ToDouble<T> divide(ToLong<T> first, long second) {
        return DivideUtil.longDivideLong(first, second);
    }

    public static <T> ToDouble<T> divide(ToLong<T> first, double second) {
        return DivideUtil.longDivideDouble(first, second);
    }

    public static <T> ToDouble<T> divide(ToLong<T> first, ToInt<T> second) {
        return DivideUtil.longDivideInt(first, second);
    }

    public static <T> ToDouble<T> divide(ToLong<T> first, ToLong<T> second) {
        return DivideUtil.longDivideLong(first, second);
    }

    public static <T> ToDouble<T> divide(ToLong<T> first, ToDouble<T> second) {
        return DivideUtil.longDivideDouble(first, second);
    }

    public static <T> ToDouble<T> divide(ToFloat<T> first, int second) {
        return DivideUtil.floatDivideInt(first, second);
    }

    public static <T> ToDouble<T> divide(ToFloat<T> first, long second) {
        return DivideUtil.floatDivideLong(first, second);
    }

    public static <T> ToDouble<T> divide(ToFloat<T> first, double second) {
        return DivideUtil.floatDivideDouble(first, second);
    }

    public static <T> ToDouble<T> divide(ToFloat<T> first, ToInt<T> second) {
        return DivideUtil.floatDivideInt(first, second);
    }

    public static <T> ToDouble<T> divide(ToFloat<T> first, ToLong<T> second) {
        return DivideUtil.floatDivideLong(first, second);
    }

    public static <T> ToDouble<T> divide(ToFloat<T> first, ToDouble<T> second) {
        return DivideUtil.floatDivideDouble(first, second);
    }

    public static <T> ToDouble<T> divide(ToDouble<T> first, int second) {
        return DivideUtil.doubleDivideInt(first, second);
    }

    public static <T> ToDouble<T> divide(ToDouble<T> first, long second) {
        return DivideUtil.doubleDivideLong(first, second);
    }

    public static <T> ToDouble<T> divide(ToDouble<T> first, double second) {
        return DivideUtil.doubleDivideDouble(first, second);
    }

    public static <T> ToDouble<T> divide(ToDouble<T> first, ToInt<T> second) {
        return DivideUtil.doubleDivideInt(first, second);
    }

    public static <T> ToDouble<T> divide(ToDouble<T> first, ToLong<T> second) {
        return DivideUtil.doubleDivideLong(first, second);
    }

    public static <T> ToDouble<T> divide(ToDouble<T> first, ToDouble<T> second) {
        return DivideUtil.doubleDivideDouble(first, second);
    }

    public static <T> ToString<T> joining(ToString<T> first, ToString<T> second) {
        return Expressions.joining((CharSequence)"", first, second);
    }

    public static <T> ToString<T> joining(CharSequence separator, ToString<T> first, ToString<T> second) {
        return Expressions.joining(separator, (CharSequence)"", (CharSequence)"", first, second);
    }

    public static <T> ToString<T> joining(CharSequence separator, CharSequence prefix, CharSequence suffix, ToString<T> first, ToString<T> second) {
        return new BinaryJoiningExpressionImpl<T>(separator, prefix, suffix, first, second);
    }

    @SafeVarargs
    public static <T> ToString<T> joining(ToString<T> ... expressions) {
        return Expressions.joining((CharSequence)"", expressions);
    }

    @SafeVarargs
    public static <T> ToString<T> joining(CharSequence separator, ToString<T> ... expressions) {
        return Expressions.joining(separator, (CharSequence)"", (CharSequence)"", expressions);
    }

    @SafeVarargs
    public static <T> ToString<T> joining(CharSequence separator, CharSequence prefix, CharSequence suffix, ToString<T> ... expressions) {
        return new JoiningExpressionImpl<T>(separator, prefix, suffix, Arrays.asList(expressions));
    }
}

