/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute.internal.expression;

import com.speedment.runtime.compute.ToBigDecimalNullable;
import com.speedment.runtime.compute.ToBooleanNullable;
import com.speedment.runtime.compute.ToByteNullable;
import com.speedment.runtime.compute.ToCharNullable;
import com.speedment.runtime.compute.ToDoubleNullable;
import com.speedment.runtime.compute.ToEnumNullable;
import com.speedment.runtime.compute.ToFloatNullable;
import com.speedment.runtime.compute.ToIntNullable;
import com.speedment.runtime.compute.ToLongNullable;
import com.speedment.runtime.compute.ToShortNullable;
import com.speedment.runtime.compute.ToStringNullable;
import com.speedment.runtime.compute.expression.Expression;
import com.speedment.runtime.compute.expression.NonNullableExpression;
import com.speedment.runtime.compute.expression.orelse.ToBigDecimalOrElse;
import com.speedment.runtime.compute.expression.orelse.ToBooleanOrElse;
import com.speedment.runtime.compute.expression.orelse.ToByteOrElse;
import com.speedment.runtime.compute.expression.orelse.ToCharOrElse;
import com.speedment.runtime.compute.expression.orelse.ToDoubleOrElse;
import com.speedment.runtime.compute.expression.orelse.ToEnumOrElse;
import com.speedment.runtime.compute.expression.orelse.ToFloatOrElse;
import com.speedment.runtime.compute.expression.orelse.ToIntOrElse;
import com.speedment.runtime.compute.expression.orelse.ToLongOrElse;
import com.speedment.runtime.compute.expression.orelse.ToShortOrElse;
import com.speedment.runtime.compute.expression.orelse.ToStringOrElse;
import java.math.BigDecimal;
import java.util.Objects;

public final class OrElseUtil {
    public static <T> ToDoubleOrElse<T> doubleOrElse(ToDoubleNullable<T> expression, double defaultValue) {
        return new ToDoubleOrElseImpl<T>(expression, defaultValue);
    }

    public static <T> ToFloatOrElse<T> floatOrElse(ToFloatNullable<T> expression, float defaultValue) {
        return new ToFloatOrElseImpl<T>(expression, defaultValue);
    }

    public static <T> ToLongOrElse<T> longOrElse(ToLongNullable<T> expression, long defaultValue) {
        return new ToLongOrElseImpl<T>(expression, defaultValue);
    }

    public static <T> ToIntOrElse<T> intOrElse(ToIntNullable<T> expression, int defaultValue) {
        return new ToIntOrElseImpl<T>(expression, defaultValue);
    }

    public static <T> ToShortOrElse<T> shortOrElse(ToShortNullable<T> expression, short defaultValue) {
        return new ToShortOrElseImpl<T>(expression, defaultValue);
    }

    public static <T> ToByteOrElse<T> byteOrElse(ToByteNullable<T> expression, byte defaultValue) {
        return new ToByteOrElseImpl<T>(expression, defaultValue);
    }

    public static <T> ToCharOrElse<T> charOrElse(ToCharNullable<T> expression, char defaultValue) {
        return new ToCharOrElseImpl<T>(expression, defaultValue);
    }

    public static <T> ToBooleanOrElse<T> booleanOrElse(ToBooleanNullable<T> expression, boolean defaultValue) {
        return new ToBooleanOrElseImpl<T>(expression, defaultValue);
    }

    public static <T> ToStringOrElse<T> stringOrElse(ToStringNullable<T> expression, String defaultValue) {
        return new ToStringOrElseImpl<T>(expression, defaultValue);
    }

    public static <T, E extends Enum<E>> ToEnumOrElse<T, E> enumOrElse(ToEnumNullable<T, E> expression, E defaultValue) {
        return new ToEnumOrElseImpl<T, E>(expression, defaultValue);
    }

    public static <T> ToBigDecimalOrElse<T> bigDecimalOrElse(ToBigDecimalNullable<T> expression, BigDecimal defaultValue) {
        return new ToBigDecimalOrElseImpl<T>(expression, defaultValue);
    }

    private OrElseUtil() {
    }

    private static abstract class AbstractNonNullable<T, INNER extends Expression<T>>
    implements NonNullableExpression<T, INNER> {
        final INNER inner;

        AbstractNonNullable(INNER inner) {
            this.inner = (Expression)Objects.requireNonNull(inner);
        }

        @Override
        public final INNER innerNullable() {
            return this.inner;
        }
    }

    static final class ToBigDecimalOrElseImpl<T>
    extends AbstractNonNullable<T, ToBigDecimalNullable<T>>
    implements ToBigDecimalOrElse<T> {
        private final BigDecimal value;

        ToBigDecimalOrElseImpl(ToBigDecimalNullable<T> inner, BigDecimal value) {
            super(inner);
            this.value = value;
        }

        @Override
        public BigDecimal defaultValue() {
            return this.value;
        }

        @Override
        public BigDecimal apply(T object) {
            return ((ToBigDecimalNullable)this.inner).isNull(object) ? this.value : ((ToBigDecimalNullable)this.inner).apply((Object)object);
        }

        @Override
        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ToBigDecimalOrElse)) {
                return false;
            }
            ToBigDecimalOrElse that = (ToBigDecimalOrElse)o;
            return Objects.equals(this.inner, that.innerNullable()) && Objects.equals(this.value, that.defaultValue());
        }

        public final int hashCode() {
            return Objects.hash(this.inner, this.value);
        }
    }

    static final class ToEnumOrElseImpl<T, E extends Enum<E>>
    extends AbstractNonNullable<T, ToEnumNullable<T, E>>
    implements ToEnumOrElse<T, E> {
        private final E value;

        ToEnumOrElseImpl(ToEnumNullable<T, E> inner, E value) {
            super(inner);
            this.value = value;
        }

        @Override
        public Class<E> enumClass() {
            return ((ToEnumNullable)this.inner).enumClass();
        }

        @Override
        public E defaultValue() {
            return this.value;
        }

        @Override
        public E apply(T object) {
            return (E)(((ToEnumNullable)this.inner).isNull(object) ? this.value : (Enum)((ToEnumNullable)this.inner).apply(object));
        }

        @Override
        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ToEnumOrElse)) {
                return false;
            }
            ToEnumOrElse that = (ToEnumOrElse)o;
            return Objects.equals(this.inner, that.innerNullable()) && Objects.equals(this.value, that.defaultValue());
        }

        public final int hashCode() {
            return Objects.hash(this.inner, this.value);
        }
    }

    static final class ToStringOrElseImpl<T>
    extends AbstractNonNullable<T, ToStringNullable<T>>
    implements ToStringOrElse<T> {
        private final String value;

        ToStringOrElseImpl(ToStringNullable<T> inner, String value) {
            super(inner);
            this.value = value;
        }

        @Override
        public String defaultValue() {
            return this.value;
        }

        @Override
        public String apply(T object) {
            return ((ToStringNullable)this.inner).isNull(object) ? this.value : ((ToStringNullable)this.inner).apply((Object)object);
        }

        @Override
        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ToStringOrElse)) {
                return false;
            }
            ToStringOrElse that = (ToStringOrElse)o;
            return Objects.equals(this.inner, that.innerNullable()) && Objects.equals(this.value, that.defaultValue());
        }

        public final int hashCode() {
            return Objects.hash(this.inner, this.value);
        }
    }

    static final class ToBooleanOrElseImpl<T>
    extends AbstractNonNullable<T, ToBooleanNullable<T>>
    implements ToBooleanOrElse<T> {
        private final boolean value;

        ToBooleanOrElseImpl(ToBooleanNullable<T> inner, boolean value) {
            super(inner);
            this.value = value;
        }

        @Override
        public boolean defaultValue() {
            return this.value;
        }

        @Override
        public boolean applyAsBoolean(T object) {
            return ((ToBooleanNullable)this.inner).isNull(object) ? this.value : ((ToBooleanNullable)this.inner).applyAsBoolean(object);
        }

        @Override
        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ToBooleanOrElse)) {
                return false;
            }
            ToBooleanOrElse that = (ToBooleanOrElse)o;
            return Objects.equals(this.inner, that.innerNullable()) && this.value == that.defaultValue();
        }

        public final int hashCode() {
            return Objects.hash(this.inner, this.value);
        }
    }

    static final class ToCharOrElseImpl<T>
    extends AbstractNonNullable<T, ToCharNullable<T>>
    implements ToCharOrElse<T> {
        private final char value;

        ToCharOrElseImpl(ToCharNullable<T> inner, char value) {
            super(inner);
            this.value = value;
        }

        @Override
        public char defaultValue() {
            return this.value;
        }

        public char applyAsChar(T object) {
            return ((ToCharNullable)this.inner).isNull(object) ? this.value : ((ToCharNullable)this.inner).applyAsChar(object);
        }

        @Override
        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ToCharOrElse)) {
                return false;
            }
            ToCharOrElse that = (ToCharOrElse)o;
            return Objects.equals(this.inner, that.innerNullable()) && this.value == that.defaultValue();
        }

        public final int hashCode() {
            return Objects.hash(this.inner, Character.valueOf(this.value));
        }
    }

    static final class ToByteOrElseImpl<T>
    extends AbstractNonNullable<T, ToByteNullable<T>>
    implements ToByteOrElse<T> {
        private final byte value;

        ToByteOrElseImpl(ToByteNullable<T> inner, byte value) {
            super(inner);
            this.value = value;
        }

        @Override
        public byte defaultValue() {
            return this.value;
        }

        @Override
        public byte applyAsByte(T object) {
            return ((ToByteNullable)this.inner).isNull(object) ? this.value : ((ToByteNullable)this.inner).applyAsByte(object);
        }

        @Override
        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ToByteOrElse)) {
                return false;
            }
            ToByteOrElse that = (ToByteOrElse)o;
            return Objects.equals(this.inner, that.innerNullable()) && this.value == that.defaultValue();
        }

        public final int hashCode() {
            return Objects.hash(this.inner, this.value);
        }
    }

    static final class ToShortOrElseImpl<T>
    extends AbstractNonNullable<T, ToShortNullable<T>>
    implements ToShortOrElse<T> {
        private final short value;

        ToShortOrElseImpl(ToShortNullable<T> inner, short value) {
            super(inner);
            this.value = value;
        }

        @Override
        public short defaultValue() {
            return this.value;
        }

        @Override
        public short applyAsShort(T object) {
            return ((ToShortNullable)this.inner).isNull(object) ? this.value : ((ToShortNullable)this.inner).applyAsShort(object);
        }

        @Override
        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ToShortOrElse)) {
                return false;
            }
            ToShortOrElse that = (ToShortOrElse)o;
            return Objects.equals(this.inner, that.innerNullable()) && this.value == that.defaultValue();
        }

        public final int hashCode() {
            return Objects.hash(this.inner, this.value);
        }
    }

    static final class ToIntOrElseImpl<T>
    extends AbstractNonNullable<T, ToIntNullable<T>>
    implements ToIntOrElse<T> {
        private final int value;

        ToIntOrElseImpl(ToIntNullable<T> inner, int value) {
            super(inner);
            this.value = value;
        }

        @Override
        public int defaultValue() {
            return this.value;
        }

        @Override
        public int applyAsInt(T object) {
            return ((ToIntNullable)this.inner).isNull(object) ? this.value : ((ToIntNullable)this.inner).applyAsInt(object);
        }

        @Override
        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ToIntOrElse)) {
                return false;
            }
            ToIntOrElse that = (ToIntOrElse)o;
            return Objects.equals(this.inner, that.innerNullable()) && this.value == that.defaultValue();
        }

        public final int hashCode() {
            return Objects.hash(this.inner, this.value);
        }
    }

    static final class ToLongOrElseImpl<T>
    extends AbstractNonNullable<T, ToLongNullable<T>>
    implements ToLongOrElse<T> {
        private final long value;

        ToLongOrElseImpl(ToLongNullable<T> inner, long value) {
            super(inner);
            this.value = value;
        }

        @Override
        public long defaultValue() {
            return this.value;
        }

        @Override
        public long applyAsLong(T object) {
            return ((ToLongNullable)this.inner).isNull(object) ? this.value : ((ToLongNullable)this.inner).applyAsLong(object);
        }

        @Override
        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ToLongOrElse)) {
                return false;
            }
            ToLongOrElse that = (ToLongOrElse)o;
            return Objects.equals(this.inner, that.innerNullable()) && this.value == that.defaultValue();
        }

        public final int hashCode() {
            return Objects.hash(this.inner, this.value);
        }
    }

    static final class ToFloatOrElseImpl<T>
    extends AbstractNonNullable<T, ToFloatNullable<T>>
    implements ToFloatOrElse<T> {
        private final float value;

        ToFloatOrElseImpl(ToFloatNullable<T> inner, float value) {
            super(inner);
            this.value = value;
        }

        @Override
        public float defaultValue() {
            return this.value;
        }

        @Override
        public float applyAsFloat(T object) {
            return ((ToFloatNullable)this.inner).isNull(object) ? this.value : ((ToFloatNullable)this.inner).applyAsFloat(object);
        }

        @Override
        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ToFloatOrElse)) {
                return false;
            }
            ToFloatOrElse that = (ToFloatOrElse)o;
            return Objects.equals(this.inner, that.innerNullable()) && this.value == that.defaultValue();
        }

        public final int hashCode() {
            return Objects.hash(this.inner, Float.valueOf(this.value));
        }
    }

    static final class ToDoubleOrElseImpl<T>
    extends AbstractNonNullable<T, ToDoubleNullable<T>>
    implements ToDoubleOrElse<T> {
        private final double value;

        ToDoubleOrElseImpl(ToDoubleNullable<T> inner, double value) {
            super(inner);
            this.value = value;
        }

        @Override
        public double defaultValue() {
            return this.value;
        }

        @Override
        public double applyAsDouble(T object) {
            return ((ToDoubleNullable)this.inner).isNull(object) ? this.value : ((ToDoubleNullable)this.inner).applyAsDouble(object);
        }

        @Override
        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ToDoubleOrElse)) {
                return false;
            }
            ToDoubleOrElse that = (ToDoubleOrElse)o;
            return Objects.equals(this.inner, that.innerNullable()) && this.value == that.defaultValue();
        }

        public final int hashCode() {
            return Objects.hash(this.inner, this.value);
        }
    }
}

