/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute.internal.expression;

import com.speedment.runtime.compute.ToByte;
import com.speedment.runtime.compute.ToDouble;
import com.speedment.runtime.compute.ToFloat;
import com.speedment.runtime.compute.ToInt;
import com.speedment.runtime.compute.ToLong;
import com.speedment.runtime.compute.ToShort;
import com.speedment.runtime.compute.expression.BinaryExpression;
import com.speedment.runtime.compute.expression.BinaryObjExpression;
import com.speedment.runtime.compute.expression.Expression;
import java.util.Objects;

public final class PowUtil {
    public static <T> ToDouble<T> bytePowInt(ToByte<T> expression, int power) {
        switch (power) {
            case 0: {
                return ToDouble.constant(1.0);
            }
            case 1: {
                return expression.asDouble();
            }
            case 2: {
                return new IntPower<T, ToByte<T>>(expression, 2){

                    @Override
                    public double applyAsDouble(T object) {
                        double value = ((ToByte)this.inner).applyAsByte(object);
                        return value * value;
                    }
                };
            }
            case 3: {
                return new IntPower<T, ToByte<T>>(expression, 3){

                    @Override
                    public double applyAsDouble(T object) {
                        double value = ((ToByte)this.inner).applyAsByte(object);
                        return value * value * value;
                    }
                };
            }
            case -1: {
                return new IntPower<T, ToByte<T>>(expression, -1){

                    @Override
                    public double applyAsDouble(T object) {
                        return 1.0 / (double)((ToByte)this.inner).applyAsByte(object);
                    }
                };
            }
        }
        return new IntPower<T, ToByte<T>>(expression, power){

            @Override
            public double applyAsDouble(T object) {
                return Math.pow(((ToByte)this.inner).applyAsByte(object), this.power);
            }
        };
    }

    public static <T> ToDouble<T> bytePowDouble(ToByte<T> expression, double power) {
        return new DoublePower<T, ToByte<T>>(expression, power){

            @Override
            public double applyAsDouble(T object) {
                return Math.pow(((ToByte)this.inner).applyAsByte(object), this.power);
            }
        };
    }

    public static <T> ToDouble<T> bytePowInt(ToByte<T> expression, ToInt<T> power) {
        return new ToIntPower<T, ToByte<T>>(expression, power){

            @Override
            public double applyAsDouble(T object) {
                int p = this.power.applyAsInt(object);
                if (p == 0) {
                    return 1.0;
                }
                double value = ((ToByte)this.inner).applyAsByte(object);
                switch (p) {
                    case 1: {
                        return value;
                    }
                    case 2: {
                        return value * value;
                    }
                    case 3: {
                        return value * value * value;
                    }
                    case 4: {
                        return value * value * value * value;
                    }
                    case 5: {
                        return value * value * value * value * value;
                    }
                    case -1: {
                        return 1.0 / value;
                    }
                }
                return Math.pow(value, p);
            }
        };
    }

    public static <T> ToDouble<T> bytePowDouble(ToByte<T> expression, ToDouble<T> power) {
        return new ToDoublePower<T, ToByte<T>>(expression, power){

            @Override
            public double applyAsDouble(T object) {
                return Math.pow(((ToByte)this.inner).applyAsByte(object), this.power.applyAsDouble(object));
            }
        };
    }

    public static <T> ToDouble<T> shortPowInt(ToShort<T> expression, int power) {
        switch (power) {
            case 0: {
                return ToDouble.constant(1.0);
            }
            case 1: {
                return expression.asDouble();
            }
            case 2: {
                return new IntPower<T, ToShort<T>>(expression, 2){

                    @Override
                    public double applyAsDouble(T object) {
                        double value = ((ToShort)this.inner).applyAsShort(object);
                        return value * value;
                    }
                };
            }
            case 3: {
                return new IntPower<T, ToShort<T>>(expression, 3){

                    @Override
                    public double applyAsDouble(T object) {
                        double value = ((ToShort)this.inner).applyAsShort(object);
                        return value * value * value;
                    }
                };
            }
            case -1: {
                return new IntPower<T, ToShort<T>>(expression, -1){

                    @Override
                    public double applyAsDouble(T object) {
                        return 1.0 / (double)((ToShort)this.inner).applyAsShort(object);
                    }
                };
            }
        }
        return new IntPower<T, ToShort<T>>(expression, power){

            @Override
            public double applyAsDouble(T object) {
                return Math.pow(((ToShort)this.inner).applyAsShort(object), this.power);
            }
        };
    }

    public static <T> ToDouble<T> shortPowDouble(ToShort<T> expression, double power) {
        return new DoublePower<T, ToShort<T>>(expression, power){

            @Override
            public double applyAsDouble(T object) {
                return Math.pow(((ToShort)this.inner).applyAsShort(object), this.power);
            }
        };
    }

    public static <T> ToDouble<T> shortPowInt(ToShort<T> expression, ToInt<T> power) {
        return new ToIntPower<T, ToShort<T>>(expression, power){

            @Override
            public double applyAsDouble(T object) {
                int p = this.power.applyAsInt(object);
                if (p == 0) {
                    return 1.0;
                }
                double value = ((ToShort)this.inner).applyAsShort(object);
                switch (p) {
                    case 1: {
                        return value;
                    }
                    case 2: {
                        return value * value;
                    }
                    case 3: {
                        return value * value * value;
                    }
                    case 4: {
                        return value * value * value * value;
                    }
                    case 5: {
                        return value * value * value * value * value;
                    }
                    case -1: {
                        return 1.0 / value;
                    }
                }
                return Math.pow(value, p);
            }
        };
    }

    public static <T> ToDouble<T> shortPowDouble(ToShort<T> expression, ToDouble<T> power) {
        return new ToDoublePower<T, ToShort<T>>(expression, power){

            @Override
            public double applyAsDouble(T object) {
                return Math.pow(((ToShort)this.inner).applyAsShort(object), this.power.applyAsDouble(object));
            }
        };
    }

    public static <T> ToDouble<T> intPowInt(ToInt<T> expression, int power) {
        switch (power) {
            case 0: {
                return ToDouble.constant(1.0);
            }
            case 1: {
                return expression.asDouble();
            }
            case 2: {
                return new IntPower<T, ToInt<T>>(expression, 2){

                    @Override
                    public double applyAsDouble(T object) {
                        double value = ((ToInt)this.inner).applyAsInt(object);
                        return value * value;
                    }
                };
            }
            case 3: {
                return new IntPower<T, ToInt<T>>(expression, 3){

                    @Override
                    public double applyAsDouble(T object) {
                        double value = ((ToInt)this.inner).applyAsInt(object);
                        return value * value * value;
                    }
                };
            }
            case -1: {
                return new IntPower<T, ToInt<T>>(expression, -1){

                    @Override
                    public double applyAsDouble(T object) {
                        return 1.0 / (double)((ToInt)this.inner).applyAsInt(object);
                    }
                };
            }
        }
        return new IntPower<T, ToInt<T>>(expression, power){

            @Override
            public double applyAsDouble(T object) {
                return Math.pow(((ToInt)this.inner).applyAsInt(object), this.power);
            }
        };
    }

    public static <T> ToDouble<T> intPowDouble(ToInt<T> expression, double power) {
        return new DoublePower<T, ToInt<T>>(expression, power){

            @Override
            public double applyAsDouble(T object) {
                return Math.pow(((ToInt)this.inner).applyAsInt(object), this.power);
            }
        };
    }

    public static <T> ToDouble<T> intPowInt(ToInt<T> expression, ToInt<T> power) {
        return new ToIntPower<T, ToInt<T>>(expression, power){

            @Override
            public double applyAsDouble(T object) {
                int p = this.power.applyAsInt(object);
                if (p == 0) {
                    return 1.0;
                }
                double value = ((ToInt)this.inner).applyAsInt(object);
                switch (p) {
                    case 1: {
                        return value;
                    }
                    case 2: {
                        return value * value;
                    }
                    case 3: {
                        return value * value * value;
                    }
                    case 4: {
                        return value * value * value * value;
                    }
                    case 5: {
                        return value * value * value * value * value;
                    }
                    case -1: {
                        return 1.0 / value;
                    }
                }
                return Math.pow(value, p);
            }
        };
    }

    public static <T> ToDouble<T> intPowDouble(ToInt<T> expression, ToDouble<T> power) {
        return new ToDoublePower<T, ToInt<T>>(expression, power){

            @Override
            public double applyAsDouble(T object) {
                return Math.pow(((ToInt)this.inner).applyAsInt(object), this.power.applyAsDouble(object));
            }
        };
    }

    public static <T> ToDouble<T> longPowInt(ToLong<T> expression, int power) {
        switch (power) {
            case 0: {
                return ToDouble.constant(1.0);
            }
            case 1: {
                return expression.asDouble();
            }
            case 2: {
                return new IntPower<T, ToLong<T>>(expression, 2){

                    @Override
                    public double applyAsDouble(T object) {
                        double value = ((ToLong)this.inner).applyAsLong(object);
                        return value * value;
                    }
                };
            }
            case 3: {
                return new IntPower<T, ToLong<T>>(expression, 3){

                    @Override
                    public double applyAsDouble(T object) {
                        double value = ((ToLong)this.inner).applyAsLong(object);
                        return value * value * value;
                    }
                };
            }
            case -1: {
                return new IntPower<T, ToLong<T>>(expression, -1){

                    @Override
                    public double applyAsDouble(T object) {
                        return 1.0 / (double)((ToLong)this.inner).applyAsLong(object);
                    }
                };
            }
        }
        return new IntPower<T, ToLong<T>>(expression, power){

            @Override
            public double applyAsDouble(T object) {
                return Math.pow(((ToLong)this.inner).applyAsLong(object), this.power);
            }
        };
    }

    public static <T> ToDouble<T> longPowDouble(ToLong<T> expression, double power) {
        return new DoublePower<T, ToLong<T>>(expression, power){

            @Override
            public double applyAsDouble(T object) {
                return Math.pow(((ToLong)this.inner).applyAsLong(object), this.power);
            }
        };
    }

    public static <T> ToDouble<T> longPowInt(ToLong<T> expression, ToInt<T> power) {
        return new ToIntPower<T, ToLong<T>>(expression, power){

            @Override
            public double applyAsDouble(T object) {
                int p = this.power.applyAsInt(object);
                if (p == 0) {
                    return 1.0;
                }
                double value = ((ToLong)this.inner).applyAsLong(object);
                switch (p) {
                    case 1: {
                        return value;
                    }
                    case 2: {
                        return value * value;
                    }
                    case 3: {
                        return value * value * value;
                    }
                    case 4: {
                        return value * value * value * value;
                    }
                    case 5: {
                        return value * value * value * value * value;
                    }
                    case -1: {
                        return 1.0 / value;
                    }
                }
                return Math.pow(value, p);
            }
        };
    }

    public static <T> ToDouble<T> longPowDouble(ToLong<T> expression, ToDouble<T> power) {
        return new ToDoublePower<T, ToLong<T>>(expression, power){

            @Override
            public double applyAsDouble(T object) {
                return Math.pow(((ToLong)this.inner).applyAsLong(object), this.power.applyAsDouble(object));
            }
        };
    }

    public static <T> ToDouble<T> floatPowInt(ToFloat<T> expression, int power) {
        switch (power) {
            case 0: {
                return ToDouble.constant(1.0);
            }
            case 1: {
                return expression.asDouble();
            }
            case 2: {
                return new IntPower<T, ToFloat<T>>(expression, 2){

                    @Override
                    public double applyAsDouble(T object) {
                        float value = ((ToFloat)this.inner).applyAsFloat(object);
                        return value * value;
                    }
                };
            }
            case 3: {
                return new IntPower<T, ToFloat<T>>(expression, 3){

                    @Override
                    public double applyAsDouble(T object) {
                        float value = ((ToFloat)this.inner).applyAsFloat(object);
                        return value * value * value;
                    }
                };
            }
            case -1: {
                return new IntPower<T, ToFloat<T>>(expression, -1){

                    @Override
                    public double applyAsDouble(T object) {
                        return 1.0f / ((ToFloat)this.inner).applyAsFloat(object);
                    }
                };
            }
        }
        return new IntPower<T, ToFloat<T>>(expression, power){

            @Override
            public double applyAsDouble(T object) {
                return Math.pow(((ToFloat)this.inner).applyAsFloat(object), this.power);
            }
        };
    }

    public static <T> ToDouble<T> floatPowDouble(ToFloat<T> expression, double power) {
        return new DoublePower<T, ToFloat<T>>(expression, power){

            @Override
            public double applyAsDouble(T object) {
                return Math.pow(((ToFloat)this.inner).applyAsFloat(object), this.power);
            }
        };
    }

    public static <T> ToDouble<T> floatPowInt(ToFloat<T> expression, ToInt<T> power) {
        return new ToIntPower<T, ToFloat<T>>(expression, power){

            @Override
            public double applyAsDouble(T object) {
                int p = this.power.applyAsInt(object);
                if (p == 0) {
                    return 1.0;
                }
                float value = ((ToFloat)this.inner).applyAsFloat(object);
                switch (p) {
                    case 1: {
                        return value;
                    }
                    case 2: {
                        return value * value;
                    }
                    case 3: {
                        return value * value * value;
                    }
                    case 4: {
                        return value * value * value * value;
                    }
                    case 5: {
                        return value * value * value * value * value;
                    }
                    case -1: {
                        return 1.0f / value;
                    }
                }
                return Math.pow(value, p);
            }
        };
    }

    public static <T> ToDouble<T> floatPowDouble(ToFloat<T> expression, ToDouble<T> power) {
        return new ToDoublePower<T, ToFloat<T>>(expression, power){

            @Override
            public double applyAsDouble(T object) {
                return Math.pow(((ToFloat)this.inner).applyAsFloat(object), this.power.applyAsDouble(object));
            }
        };
    }

    public static <T> ToDouble<T> doublePowInt(ToDouble<T> expression, int power) {
        switch (power) {
            case 0: {
                return ToDouble.constant(1.0);
            }
            case 1: {
                return expression.asDouble();
            }
            case 2: {
                return new IntPower<T, ToDouble<T>>(expression, 2){

                    @Override
                    public double applyAsDouble(T object) {
                        double value = ((ToDouble)this.inner).applyAsDouble(object);
                        return value * value;
                    }
                };
            }
            case 3: {
                return new IntPower<T, ToDouble<T>>(expression, 3){

                    @Override
                    public double applyAsDouble(T object) {
                        double value = ((ToDouble)this.inner).applyAsDouble(object);
                        return value * value * value;
                    }
                };
            }
            case -1: {
                return new IntPower<T, ToDouble<T>>(expression, -1){

                    @Override
                    public double applyAsDouble(T object) {
                        return 1.0 / ((ToDouble)this.inner).applyAsDouble(object);
                    }
                };
            }
        }
        return new IntPower<T, ToDouble<T>>(expression, power){

            @Override
            public double applyAsDouble(T object) {
                return Math.pow(((ToDouble)this.inner).applyAsDouble(object), this.power);
            }
        };
    }

    public static <T> ToDouble<T> doublePowDouble(ToDouble<T> expression, double power) {
        return new DoublePower<T, ToDouble<T>>(expression, power){

            @Override
            public double applyAsDouble(T object) {
                return Math.pow(((ToDouble)this.inner).applyAsDouble(object), this.power);
            }
        };
    }

    public static <T> ToDouble<T> doublePowInt(ToDouble<T> expression, ToInt<T> power) {
        return new ToIntPower<T, ToDouble<T>>(expression, power){

            @Override
            public double applyAsDouble(T object) {
                int p = this.power.applyAsInt(object);
                if (p == 0) {
                    return 1.0;
                }
                double value = ((ToDouble)this.inner).applyAsDouble(object);
                switch (p) {
                    case 1: {
                        return value;
                    }
                    case 2: {
                        return value * value;
                    }
                    case 3: {
                        return value * value * value;
                    }
                    case 4: {
                        return value * value * value * value;
                    }
                    case 5: {
                        return value * value * value * value * value;
                    }
                    case -1: {
                        return 1.0 / value;
                    }
                }
                return Math.pow(value, p);
            }
        };
    }

    public static <T> ToDouble<T> doublePowDouble(ToDouble<T> expression, ToDouble<T> power) {
        return new ToDoublePower<T, ToDouble<T>>(expression, power){

            @Override
            public double applyAsDouble(T object) {
                return Math.pow(((ToDouble)this.inner).applyAsDouble(object), this.power.applyAsDouble(object));
            }
        };
    }

    private PowUtil() {
    }

    static abstract class ToDoublePower<T, INNER extends Expression<T>>
    implements BinaryExpression<T, INNER, ToDouble<T>>,
    ToDouble<T> {
        final INNER inner;
        final ToDouble<T> power;

        ToDoublePower(INNER inner, ToDouble<T> power) {
            this.inner = (Expression)Objects.requireNonNull(inner);
            this.power = Objects.requireNonNull(power);
        }

        @Override
        public final INNER first() {
            return this.inner;
        }

        @Override
        public final ToDouble<T> second() {
            return this.power;
        }

        @Override
        public final BinaryExpression.Operator operator() {
            return BinaryExpression.Operator.POW;
        }

        @Override
        public final boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (!(o instanceof BinaryExpression)) {
                return false;
            }
            BinaryExpression that = (BinaryExpression)o;
            return Objects.equals(this.inner, that.first()) && Objects.equals(this.power, that.second()) && Objects.equals((Object)this.operator(), (Object)that.operator());
        }

        public final int hashCode() {
            return Objects.hash(new Object[]{this.inner, this.power, this.operator()});
        }
    }

    static abstract class ToIntPower<T, INNER extends Expression<T>>
    implements BinaryExpression<T, INNER, ToInt<T>>,
    ToDouble<T> {
        final INNER inner;
        final ToInt<T> power;

        ToIntPower(INNER inner, ToInt<T> power) {
            this.inner = (Expression)Objects.requireNonNull(inner);
            this.power = Objects.requireNonNull(power);
        }

        @Override
        public final INNER first() {
            return this.inner;
        }

        @Override
        public final ToInt<T> second() {
            return this.power;
        }

        @Override
        public final BinaryExpression.Operator operator() {
            return BinaryExpression.Operator.POW;
        }

        @Override
        public final boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (!(o instanceof BinaryExpression)) {
                return false;
            }
            BinaryExpression that = (BinaryExpression)o;
            return Objects.equals(this.inner, that.first()) && Objects.equals(this.power, that.second()) && Objects.equals((Object)this.operator(), (Object)that.operator());
        }

        public final int hashCode() {
            return Objects.hash(new Object[]{this.inner, this.power, this.operator()});
        }
    }

    static abstract class DoublePower<T, INNER extends Expression<T>>
    implements BinaryObjExpression<T, INNER, Double>,
    ToDouble<T> {
        final INNER inner;
        final double power;

        DoublePower(INNER inner, double power) {
            this.inner = (Expression)Objects.requireNonNull(inner);
            this.power = power;
        }

        @Override
        public final INNER first() {
            return this.inner;
        }

        @Override
        public final Double second() {
            return this.power;
        }

        @Override
        public final BinaryObjExpression.Operator operator() {
            return BinaryObjExpression.Operator.POW;
        }

        @Override
        public final boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (!(o instanceof BinaryObjExpression)) {
                return false;
            }
            BinaryObjExpression that = (BinaryObjExpression)o;
            return Objects.equals(this.inner, that.first()) && Objects.equals(this.power, that.second()) && Objects.equals((Object)this.operator(), (Object)that.operator());
        }

        public final int hashCode() {
            return Objects.hash(new Object[]{this.inner, this.power, this.operator()});
        }
    }

    static abstract class IntPower<T, INNER extends Expression<T>>
    implements BinaryObjExpression<T, INNER, Integer>,
    ToDouble<T> {
        final INNER inner;
        final int power;

        IntPower(INNER inner, int power) {
            this.inner = (Expression)Objects.requireNonNull(inner);
            this.power = power;
        }

        @Override
        public final INNER first() {
            return this.inner;
        }

        @Override
        public final Integer second() {
            return this.power;
        }

        @Override
        public final BinaryObjExpression.Operator operator() {
            return BinaryObjExpression.Operator.POW;
        }

        @Override
        public final boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (!(o instanceof BinaryObjExpression)) {
                return false;
            }
            BinaryObjExpression that = (BinaryObjExpression)o;
            return Objects.equals(this.inner, that.first()) && Objects.equals(this.power, that.second()) && Objects.equals((Object)this.operator(), (Object)that.operator());
        }

        public final int hashCode() {
            return Objects.hash(new Object[]{this.inner, this.power, this.operator()});
        }
    }
}

