/*
 * Decompiled with CFR 0.152.
 */
package com.spencerwi.hamcrestJDK8Time.matchers;

import java.time.temporal.Temporal;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.TypeSafeMatcher;

public class IsBetween<T extends Temporal & Comparable<T>>
extends TypeSafeMatcher<T> {
    private T start;
    private T end;

    public IsBetween(T start, T end) {
        this.start = start;
        this.end = end;
    }

    protected boolean matchesSafely(T item) {
        boolean isAtOrAfterStart = ((Comparable)item).compareTo(this.start) >= 0;
        boolean isAtOrBeforeEnd = ((Comparable)item).compareTo(this.end) <= 0;
        return isAtOrAfterStart && isAtOrBeforeEnd;
    }

    public void describeTo(Description description) {
        description.appendText("a " + this.start.getClass().getSimpleName() + " between ").appendValue(this.start).appendText(" and ").appendValue(this.end).appendText(", inclusively");
    }

    @Factory
    public static <T extends Temporal & Comparable<T>> IsBetween<T> between(T start, T end) {
        return new IsBetween<T>(start, end);
    }
}

