/*
 * Decompiled with CFR 0.152.
 */
package com.spencerwi.hamcrestJDK8Time.matchers;

import java.time.temporal.Temporal;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.TypeSafeMatcher;

public class IsStrictlyBetween<T extends Temporal & Comparable<T>>
extends TypeSafeMatcher<T> {
    private T start;
    private T end;

    public IsStrictlyBetween(T start, T end) {
        this.start = start;
        this.end = end;
    }

    protected boolean matchesSafely(T item) {
        boolean isAfterStart = ((Comparable)item).compareTo(this.start) > 0;
        boolean isBeforeEnd = ((Comparable)item).compareTo(this.end) < 0;
        return isAfterStart && isBeforeEnd;
    }

    public void describeTo(Description description) {
        description.appendText("a " + this.start.getClass().getSimpleName() + " strictly between ").appendValue(this.start).appendText(" and ").appendValue(this.end);
    }

    @Factory
    public static <T extends Temporal & Comparable<T>> IsStrictlyBetween<T> strictlyBetween(T start, T end) {
        return new IsStrictlyBetween<T>(start, end);
    }
}

