/*
 * Decompiled with CFR 0.152.
 */
package com.spencerwi.hamcrestJDK8Time.matchers;

import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class IsWithin<T extends Temporal & Comparable<? super T>>
extends TypeSafeMatcher<T> {
    private long window;
    private TemporalUnit units;
    private T other;

    public IsWithin(long window, TemporalUnit units, T other) {
        this.window = window;
        this.units = units;
        this.other = other;
    }

    protected boolean matchesSafely(T item) {
        Temporal startOfWindow = this.other.minus(this.window, this.units);
        Temporal endOfWindow = this.other.plus(this.window, this.units);
        return ((Comparable)((Object)startOfWindow)).compareTo(item) <= 0 && ((Comparable)((Object)endOfWindow)).compareTo(item) >= 0;
    }

    public void describeTo(Description description) {
        description.appendText("a " + this.other.getClass().getSimpleName() + " that is within ").appendValue((Object)this.window).appendText(" ").appendValue((Object)this.units).appendText(" of ").appendValue(this.other);
    }

    public static Builder within(long window, TemporalUnit units) {
        return new Builder(window, units);
    }

    public static class Builder {
        private long window;
        private TemporalUnit units;

        private Builder(long window, TemporalUnit units) {
            this.window = window;
            this.units = units;
        }

        public <T extends Temporal & Comparable<? super T>> IsWithin<T> of(T other) {
            return new IsWithin<T>(this.window, this.units, other);
        }
    }
}

