/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.dispatch;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import com.spotify.apollo.RequestContext;
import com.spotify.apollo.Response;
import com.spotify.apollo.Status;
import com.spotify.apollo.StatusType;
import com.spotify.apollo.dispatch.Endpoint;
import com.spotify.apollo.request.EndpointRunnableFactory;
import com.spotify.apollo.request.OngoingRequest;
import java.util.concurrent.CompletionException;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointInvocationHandler
implements EndpointRunnableFactory {
    private static final Logger LOG = LoggerFactory.getLogger(EndpointInvocationHandler.class);

    @Override
    public Runnable create(OngoingRequest ongoingRequest, RequestContext requestContext, Endpoint endpoint) {
        return () -> this.handle(ongoingRequest, requestContext, endpoint);
    }

    void handle(OngoingRequest ongoingRequest, RequestContext requestContext, Endpoint endpoint) {
        try {
            endpoint.invoke(requestContext).whenComplete((message, throwable) -> {
                if (message != null) {
                    ongoingRequest.reply((Response<ByteString>)message);
                } else if (throwable != null) {
                    if (throwable instanceof CompletionException) {
                        throwable = throwable.getCause();
                    }
                    EndpointInvocationHandler.handleException(throwable, ongoingRequest);
                } else {
                    LOG.error("Both message and throwable null in EndpointInvocationHandler for request " + ongoingRequest + " - this shouldn't happen!");
                    EndpointInvocationHandler.handleException(new IllegalStateException("Both message and throwable null"), ongoingRequest);
                }
            });
        }
        catch (Exception e) {
            EndpointInvocationHandler.handleException(e, ongoingRequest);
        }
    }

    private static void handleException(Throwable e, OngoingRequest ongoingRequest) {
        String message = e.getMessage();
        message = !Strings.isNullOrEmpty((String)message) ? ": \"" + message + "\"" : "";
        message = CharMatcher.anyOf((CharSequence)"\n\r").replaceFrom((CharSequence)message, ' ');
        LOG.warn("Got Exception {} when invoking endpoint for request: {}", new Object[]{message, ongoingRequest.request(), e});
        ongoingRequest.reply((Response<ByteString>)Response.forStatus((StatusType)Status.INTERNAL_SERVER_ERROR.withReasonPhrase(message)));
    }
}

