/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.environment;

import com.google.common.io.Closer;
import com.spotify.apollo.Client;
import com.spotify.apollo.Environment;
import com.spotify.apollo.environment.EnvironmentConfigResolver;
import com.spotify.apollo.environment.EnvironmentFactory;
import com.spotify.apollo.environment.EnvironmentImpl;
import com.spotify.apollo.environment.RoutingContextImpl;

class EnvironmentFactoryImpl
implements EnvironmentFactory {
    private final String backendDomain;
    private final Client client;
    private final EnvironmentConfigResolver configResolver;
    private EnvironmentFactory.Resolver resolver;
    private final Closer closer;

    EnvironmentFactoryImpl(String backendDomain, Client client, EnvironmentConfigResolver configResolver, EnvironmentFactory.Resolver resolver, Closer closer) {
        this.backendDomain = backendDomain;
        this.client = client;
        this.configResolver = configResolver;
        this.resolver = resolver;
        this.closer = closer;
    }

    @Override
    public Environment create(String serviceName, EnvironmentFactory.RoutingContext routingContext) {
        return new EnvironmentImpl(serviceName, this.backendDomain, this.client, this.configResolver, this.resolver, routingContext, this.closer);
    }

    @Override
    public EnvironmentFactory.RoutingContext createRoutingContext() {
        return new RoutingContextImpl();
    }
}

