/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.environment;

import com.google.common.collect.ImmutableList;
import com.spotify.apollo.Environment;
import com.spotify.apollo.Response;
import com.spotify.apollo.environment.EnvironmentFactory;
import com.spotify.apollo.route.AsyncHandler;
import com.spotify.apollo.route.Middlewares;
import com.spotify.apollo.route.Route;
import com.spotify.apollo.route.RouteProvider;
import java.util.stream.Stream;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RoutingContextImpl
implements EnvironmentFactory.RoutingContext {
    private static final Logger LOG = LoggerFactory.getLogger(RoutingContextImpl.class);
    private final ImmutableList.Builder<Object> builder = ImmutableList.builder();
    private volatile boolean built;

    RoutingContextImpl() {
    }

    @Override
    public synchronized Iterable<Object> endpointObjects() {
        this.built = true;
        return this.builder.build();
    }

    public synchronized Environment.RoutingEngine registerAutoRoutes(RouteProvider routeProvider) {
        this.ensureNotBuilt();
        routeProvider.routes().map(route -> route.withMiddleware(Middlewares.apolloDefaults())).forEach(this::addRoute);
        return this;
    }

    public synchronized Environment.RoutingEngine registerAutoRoute(Route<? extends AsyncHandler<?>> route) {
        this.ensureNotBuilt();
        this.addRoute((Route<? extends AsyncHandler<? extends Response<ByteString>>>)route.withMiddleware(Middlewares.apolloDefaults()));
        return this;
    }

    public synchronized Environment.RoutingEngine registerRoutes(Stream<? extends Route<? extends AsyncHandler<? extends Response<ByteString>>>> routes) {
        this.ensureNotBuilt();
        routes.forEach(this::addRoute);
        return this;
    }

    public synchronized Environment.RoutingEngine registerRoute(Route<? extends AsyncHandler<? extends Response<ByteString>>> route) {
        this.ensureNotBuilt();
        this.addRoute(route);
        return this;
    }

    private void addRoute(Route<? extends AsyncHandler<? extends Response<ByteString>>> route) {
        RoutingContextImpl.logRoute(route);
        this.builder.add(route);
    }

    private static void logRoute(Route<?> route) {
        LOG.info("Registering Route {} ({})", (Object)route.uri(), (Object)route.method());
    }

    private void ensureNotBuilt() {
        if (this.built) {
            throw new IllegalStateException("Routing Engine has already been initialized. This is most likely a sign of Environment.routingEngine() being used outside of application initialisation");
        }
    }
}

