/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.meta;

import com.spotify.apollo.Request;
import com.spotify.apollo.dispatch.Endpoint;
import com.spotify.apollo.dispatch.EndpointInfo;
import com.spotify.apollo.meta.Descriptor;
import com.spotify.apollo.meta.IncomingCallsGatherer;
import com.spotify.apollo.meta.OutgoingCallsGatherer;
import com.spotify.apollo.meta.model.Meta;
import com.spotify.apollo.meta.model.MetaGatherer;
import com.spotify.apollo.meta.model.MetaInfoBuilder;
import com.spotify.apollo.meta.model.Model;
import com.spotify.apollo.request.OngoingRequest;
import com.spotify.apollo.route.Route;
import com.typesafe.config.Config;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class MetaInfoTracker {
    private final MetaGatherer gatherer;
    private final IncomingGatherer incomingGatherer = new IncomingGatherer();
    private OutgoingGatherer outgoingGatherer = new OutgoingGatherer();

    public MetaInfoTracker(Descriptor descriptor, String containerVersion, Config configNode) {
        Model.MetaInfo metaInfo = new MetaInfoBuilder().buildVersion(descriptor.serviceName() + ' ' + descriptor.version()).containerVersion(containerVersion).build();
        this.gatherer = Meta.createGatherer(metaInfo, configNode);
    }

    public MetaGatherer getGatherer() {
        return this.gatherer;
    }

    public <E extends Endpoint> void gatherEndpoints(List<E> endpoints) {
        MetaGatherer.CallsGatherer callsGatherer = this.gatherer.getServiceCallsGatherer();
        for (Endpoint endpoint : endpoints) {
            EndpointInfo info = endpoint.info();
            String uri = info.getUri();
            String endpointDocString = MetaInfoTracker.formatDocString(info.getDocString());
            MetaGatherer.EndpointGatherer endpointGatherer = callsGatherer.uriMethodsEndpointGatherer(uri, Collections.singletonList(info.getRequestMethod()));
            endpointGatherer.setUri(uri);
            endpointGatherer.addMethod(info.getRequestMethod());
            endpointGatherer.setDocstring(endpointDocString);
        }
    }

    private static String formatDocString(Optional<Route.DocString> docString) {
        if (!docString.isPresent()) {
            return "Lacks DocString annotation.";
        }
        return docString.get().summary() + "\n\n" + docString.get().description();
    }

    public IncomingCallsGatherer incomingCallsGatherer() {
        return this.incomingGatherer;
    }

    public OutgoingCallsGatherer outgoingCallsGatherer() {
        return this.outgoingGatherer;
    }

    private class OutgoingGatherer
    implements OutgoingCallsGatherer {
        private OutgoingGatherer() {
        }

        @Override
        public void gatherOutgoingCall(String toService, Request request) {
            MetaGatherer.CallsGatherer callsGatherer = MetaInfoTracker.this.gatherer.getOutgoingCallsGatherer(toService);
        }
    }

    private class IncomingGatherer
    implements IncomingCallsGatherer {
        private IncomingGatherer() {
        }

        @Override
        public void gatherIncomingCall(OngoingRequest ongoingRequest, Endpoint endpoint) {
            Request message = ongoingRequest.request();
            String fromService = message.service().orElse(null);
            String method = message.method();
            EndpointInfo info = endpoint.info();
            String endpointMethodName = info.getJavaMethodName();
            MetaGatherer.CallsGatherer callsGatherer = MetaInfoTracker.this.gatherer.getIncomingCallsGatherer(fromService);
            MetaGatherer.EndpointGatherer endpointGatherer = callsGatherer.namedEndpointGatherer(endpointMethodName);
            endpointGatherer.setUri(info.getUri());
            endpointGatherer.addMethod(method);
            for (String name : message.parameters().keySet()) {
                endpointGatherer.addQueryParameterName(name);
            }
        }
    }
}

