/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.meta.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import com.typesafe.config.ConfigValueType;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

final class ConfigFilter {
    private ConfigFilter() {
    }

    static boolean metaConfigEnabled(Config rootConfig) {
        Preconditions.checkNotNull((Object)rootConfig);
        return rootConfig.hasPath("_meta.expose-config") && rootConfig.getBoolean("_meta.expose-config");
    }

    static Set<String> configFilter(Config rootConfig) {
        Preconditions.checkNotNull((Object)rootConfig);
        LinkedHashSet filter = Sets.newLinkedHashSet();
        filter.add("passw");
        filter.add("secret");
        filter.add("private");
        if (rootConfig.hasPath("_meta.config-filter")) {
            Config configFilter = rootConfig.getConfig("_meta.config-filter");
            for (Map.Entry filterEntry : configFilter.entrySet()) {
                if (((ConfigValue)filterEntry.getValue()).unwrapped() != Boolean.TRUE) continue;
                filter.add(filterEntry.getKey());
            }
        }
        return filter;
    }

    static ConfigObject filterConfigObject(ConfigObject config, Set<String> filter) {
        ConfigObject result = config;
        for (Map.Entry entry : config.entrySet()) {
            Object filteredValue;
            String key = (String)entry.getKey();
            if (!ConfigFilter.isFiltered(key, filter)) {
                ConfigValue value = (ConfigValue)entry.getValue();
                filteredValue = !"_meta".equals(key) && value.valueType() == ConfigValueType.OBJECT ? ConfigFilter.filterConfigObject((ConfigObject)value, filter) : value;
            } else {
                filteredValue = ConfigValueFactory.fromAnyRef((Object)"*******", (String)"filtered by config-filter settings");
            }
            result = result.withValue(key, filteredValue);
        }
        return result;
    }

    static boolean isFiltered(String key, Set<String> filter) {
        for (String filterSubstring : filter) {
            if (!key.contains(filterSubstring)) continue;
            return true;
        }
        return false;
    }
}

