/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.meta.model;

import com.google.common.collect.Maps;
import com.spotify.apollo.meta.model.CallsInfo;
import com.spotify.apollo.meta.model.ConfigFilter;
import com.spotify.apollo.meta.model.LoadedConfigBuilder;
import com.spotify.apollo.meta.model.MetaGatherer;
import com.spotify.apollo.meta.model.MetaInfoBuilder;
import com.spotify.apollo.meta.model.Model;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMetaGatherer
implements MetaGatherer {
    private static final Logger log = LoggerFactory.getLogger(DefaultMetaGatherer.class);
    public static final int DEFAULT_SIZE_LIMIT = 100;
    public static final String OVER_SIZE_KEY = "<over size limit>";
    private final int sizeLimit;
    private final long startTime = System.currentTimeMillis();
    private final Model.MetaInfo metaInfo;
    @Nullable
    private final Config config;
    private final CallsInfo endpoints;
    private final ConcurrentMap<String, CallsInfo> incoming = Maps.newConcurrentMap();
    private final ConcurrentMap<String, CallsInfo> outgoing = Maps.newConcurrentMap();

    DefaultMetaGatherer(Model.MetaInfo metaInfo) {
        this(100, metaInfo, null);
    }

    DefaultMetaGatherer(Model.MetaInfo metaInfo, Config config) {
        this(100, metaInfo, config);
    }

    DefaultMetaGatherer(int sizeLimit, Model.MetaInfo metaInfo, @Nullable Config config) {
        this.sizeLimit = sizeLimit;
        this.endpoints = new CallsInfo(sizeLimit);
        this.config = config;
        this.metaInfo = MetaInfoBuilder.from(metaInfo).systemVersion("java " + System.getProperty("java.version")).build();
    }

    @Override
    public synchronized Model.MetaInfo info() {
        return MetaInfoBuilder.from(this.metaInfo).serviceUptime((double)(System.currentTimeMillis() - this.startTime) / 1000.0).build();
    }

    @Override
    public synchronized Model.LoadedConfig loadedConfig() {
        return new LoadedConfigBuilder().spNode(this.filteredConfig().root()).build();
    }

    private Config filteredConfig() {
        if (this.config == null) {
            return ConfigFactory.empty();
        }
        if (!ConfigFilter.metaConfigEnabled(this.config)) {
            String disableMessage = "enable by adding '\"_meta\": { \"expose-config\": true },' to root level service config. See https://github.com/spotify/apollo/tree/master/apollo-api-impl/src/main/java/com/spotify/apollo/meta/model";
            return ConfigFactory.parseMap(Collections.singletonMap("disabled", disableMessage));
        }
        Set<String> filter = ConfigFilter.configFilter(this.config);
        return ConfigFilter.filterConfigObject(this.config.root(), filter).toConfig();
    }

    @Override
    public synchronized Model.EndpointsInfo endpoints() {
        return this.endpoints.getEndpointsInfo();
    }

    @Override
    public synchronized Model.ExternalCallsInfo calls() {
        Model.ExternalCallsInfo calls = new Model.ExternalCallsInfo();
        for (Map.Entry entry : this.incoming.entrySet()) {
            calls.incoming.put((String)entry.getKey(), ((CallsInfo)entry.getValue()).getEndpointsInfo().endpoints);
        }
        for (Map.Entry entry : this.outgoing.entrySet()) {
            calls.outgoing.put((String)entry.getKey(), ((CallsInfo)entry.getValue()).getEndpointsInfo().endpoints);
        }
        return calls;
    }

    @Override
    public MetaGatherer.CallsGatherer getServiceCallsGatherer() {
        return this.endpoints;
    }

    @Override
    public MetaGatherer.CallsGatherer getIncomingCallsGatherer(String service) {
        if (service == null) {
            service = "<null>";
        }
        if (!this.incoming.containsKey(service)) {
            if (this.incoming.size() < this.sizeLimit) {
                this.incoming.putIfAbsent(service, new CallsInfo(this.sizeLimit));
            } else {
                if (!this.incoming.containsKey(OVER_SIZE_KEY)) {
                    this.incoming.putIfAbsent(OVER_SIZE_KEY, new CallsInfo(this.sizeLimit));
                }
                return (MetaGatherer.CallsGatherer)this.incoming.get(OVER_SIZE_KEY);
            }
        }
        return (MetaGatherer.CallsGatherer)this.incoming.get(service);
    }

    @Override
    public MetaGatherer.CallsGatherer getOutgoingCallsGatherer(String service) {
        if (service == null) {
            service = "<null>";
        }
        if (!this.outgoing.containsKey(service)) {
            if (this.outgoing.size() < this.sizeLimit) {
                this.outgoing.putIfAbsent(service, new CallsInfo(this.sizeLimit));
            } else {
                if (!this.outgoing.containsKey(OVER_SIZE_KEY)) {
                    this.outgoing.putIfAbsent(OVER_SIZE_KEY, new CallsInfo(this.sizeLimit));
                }
                return (MetaGatherer.CallsGatherer)this.outgoing.get(OVER_SIZE_KEY);
            }
        }
        return (MetaGatherer.CallsGatherer)this.outgoing.get(service);
    }
}

