/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.meta.model;

import com.spotify.apollo.meta.model.Model;
import io.norberg.automatter.AutoMatter;

public final class MetaInfoBuilder {
    private String buildVersion;
    private String containerVersion;
    private String systemVersion;
    private double serviceUptime;

    public MetaInfoBuilder() {
    }

    private MetaInfoBuilder(Model.MetaInfo v) {
        this.buildVersion = v.buildVersion();
        this.containerVersion = v.containerVersion();
        this.systemVersion = v.systemVersion();
        this.serviceUptime = v.serviceUptime();
    }

    private MetaInfoBuilder(MetaInfoBuilder v) {
        this.buildVersion = v.buildVersion;
        this.containerVersion = v.containerVersion;
        this.systemVersion = v.systemVersion;
        this.serviceUptime = v.serviceUptime;
    }

    public String buildVersion() {
        return this.buildVersion;
    }

    public MetaInfoBuilder buildVersion(String buildVersion) {
        if (buildVersion == null) {
            throw new NullPointerException("buildVersion");
        }
        this.buildVersion = buildVersion;
        return this;
    }

    public String containerVersion() {
        return this.containerVersion;
    }

    public MetaInfoBuilder containerVersion(String containerVersion) {
        if (containerVersion == null) {
            throw new NullPointerException("containerVersion");
        }
        this.containerVersion = containerVersion;
        return this;
    }

    public String systemVersion() {
        return this.systemVersion;
    }

    public MetaInfoBuilder systemVersion(String systemVersion) {
        this.systemVersion = systemVersion;
        return this;
    }

    public double serviceUptime() {
        return this.serviceUptime;
    }

    public MetaInfoBuilder serviceUptime(double serviceUptime) {
        this.serviceUptime = serviceUptime;
        return this;
    }

    public Model.MetaInfo build() {
        return new Value(this.buildVersion, this.containerVersion, this.systemVersion, this.serviceUptime);
    }

    public static MetaInfoBuilder from(Model.MetaInfo v) {
        return new MetaInfoBuilder(v);
    }

    public static MetaInfoBuilder from(MetaInfoBuilder v) {
        return new MetaInfoBuilder(v);
    }

    private static final class Value
    implements Model.MetaInfo {
        private final String buildVersion;
        private final String containerVersion;
        private final String systemVersion;
        private final double serviceUptime;

        private Value(@AutoMatter.Field(value="buildVersion") String buildVersion, @AutoMatter.Field(value="containerVersion") String containerVersion, @AutoMatter.Field(value="systemVersion") String systemVersion, @AutoMatter.Field(value="serviceUptime") double serviceUptime) {
            if (buildVersion == null) {
                throw new NullPointerException("buildVersion");
            }
            if (containerVersion == null) {
                throw new NullPointerException("containerVersion");
            }
            this.buildVersion = buildVersion;
            this.containerVersion = containerVersion;
            this.systemVersion = systemVersion;
            this.serviceUptime = serviceUptime;
        }

        @Override
        @AutoMatter.Field
        public String buildVersion() {
            return this.buildVersion;
        }

        @Override
        @AutoMatter.Field
        public String containerVersion() {
            return this.containerVersion;
        }

        @Override
        @AutoMatter.Field
        public String systemVersion() {
            return this.systemVersion;
        }

        @Override
        @AutoMatter.Field
        public double serviceUptime() {
            return this.serviceUptime;
        }

        public MetaInfoBuilder builder() {
            return new MetaInfoBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Model.MetaInfo)) {
                return false;
            }
            Model.MetaInfo that = (Model.MetaInfo)o;
            if (this.buildVersion != null ? !this.buildVersion.equals(that.buildVersion()) : that.buildVersion() != null) {
                return false;
            }
            if (this.containerVersion != null ? !this.containerVersion.equals(that.containerVersion()) : that.containerVersion() != null) {
                return false;
            }
            if (this.systemVersion != null ? !this.systemVersion.equals(that.systemVersion()) : that.systemVersion() != null) {
                return false;
            }
            return Double.compare(this.serviceUptime, that.serviceUptime()) == 0;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.buildVersion != null ? this.buildVersion.hashCode() : 0);
            result = 31 * result + (this.containerVersion != null ? this.containerVersion.hashCode() : 0);
            result = 31 * result + (this.systemVersion != null ? this.systemVersion.hashCode() : 0);
            long temp = Double.doubleToLongBits(this.serviceUptime);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public String toString() {
            return "Model.MetaInfo{buildVersion=" + this.buildVersion + ", containerVersion=" + this.containerVersion + ", systemVersion=" + this.systemVersion + ", serviceUptime=" + this.serviceUptime + '}';
        }
    }
}

