/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.request;

import com.spotify.apollo.dispatch.Endpoint;
import com.spotify.apollo.dispatch.EndpointInvocationHandler;
import com.spotify.apollo.environment.IncomingRequestAwareClient;
import com.spotify.apollo.meta.IncomingCallsGatherer;
import com.spotify.apollo.request.EndpointRunnableFactory;
import com.spotify.apollo.request.RequestHandler;
import com.spotify.apollo.request.RequestHandlerImpl;
import com.spotify.apollo.request.RequestRunnableFactory;
import com.spotify.apollo.request.RequestRunnableImpl;
import com.spotify.apollo.request.RequestTracker;
import com.spotify.apollo.request.TrackingEndpointRunnableFactory;
import com.spotify.apollo.route.ApplicationRouter;

public final class Handlers {
    private Handlers() {
    }

    public static RequestHandler requestHandler(RequestRunnableFactory requestRunnableFactory, EndpointRunnableFactory endpointRunnableFactory, IncomingRequestAwareClient client) {
        return new RequestHandlerImpl(requestRunnableFactory, endpointRunnableFactory, client);
    }

    public static RequestRunnableFactory requestRunnableFactory(ApplicationRouter<Endpoint> applicationRouter) {
        return request -> new RequestRunnableImpl(request, applicationRouter);
    }

    public static EndpointRunnableFactory endpointRunnableFactory() {
        return new EndpointInvocationHandler();
    }

    public static EndpointRunnableFactory withTracking(EndpointRunnableFactory endpointRunnableFactory, IncomingCallsGatherer incomingCallsGatherer, RequestTracker requestTracker) {
        return new TrackingEndpointRunnableFactory(endpointRunnableFactory, incomingCallsGatherer, requestTracker);
    }
}

