/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.request;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.spotify.apollo.Request;
import com.spotify.apollo.Response;
import com.spotify.apollo.Status;
import com.spotify.apollo.StatusType;
import com.spotify.apollo.dispatch.Endpoint;
import com.spotify.apollo.request.OngoingRequest;
import com.spotify.apollo.request.RequestRunnable;
import com.spotify.apollo.route.ApplicationRouter;
import com.spotify.apollo.route.InvalidUriException;
import com.spotify.apollo.route.RuleMatch;
import java.util.Collection;
import java.util.Optional;
import java.util.function.BiConsumer;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RequestRunnableImpl
implements RequestRunnable {
    private static final Logger LOG = LoggerFactory.getLogger(RequestRunnableImpl.class);
    private final OngoingRequest ongoingRequest;
    private final ApplicationRouter<Endpoint> applicationRouter;

    RequestRunnableImpl(OngoingRequest ongoingRequest, ApplicationRouter<Endpoint> applicationRouter) {
        this.ongoingRequest = ongoingRequest;
        this.applicationRouter = applicationRouter;
    }

    @Override
    public void run(BiConsumer<OngoingRequest, RuleMatch<Endpoint>> matchContinuation) {
        try {
            this.matchAndRun(matchContinuation);
        }
        catch (Exception e) {
            LOG.error("Exception when handling request", (Throwable)e);
            this.ongoingRequest.reply((Response<ByteString>)Response.forStatus((StatusType)Status.INTERNAL_SERVER_ERROR));
        }
    }

    private void matchAndRun(BiConsumer<OngoingRequest, RuleMatch<Endpoint>> matchContinuation) {
        Optional match;
        Request request = this.ongoingRequest.request();
        try {
            match = this.applicationRouter.match(request);
        }
        catch (InvalidUriException e) {
            LOG.warn("bad uri {} {} {}", new Object[]{request.method(), request.uri(), Status.BAD_REQUEST, e});
            this.ongoingRequest.reply((Response<ByteString>)Response.forStatus((StatusType)Status.BAD_REQUEST));
            return;
        }
        if (!match.isPresent()) {
            Collection methods = this.applicationRouter.getMethodsForValidRules(request);
            if (methods.isEmpty()) {
                LOG.warn("not found {} {} {}", new Object[]{request.method(), request.uri(), Status.NOT_FOUND});
                this.ongoingRequest.reply((Response<ByteString>)Response.forStatus((StatusType)Status.NOT_FOUND));
            } else {
                Status statusCode;
                if ("OPTIONS".equals(request.method())) {
                    statusCode = Status.NO_CONTENT;
                } else {
                    statusCode = Status.METHOD_NOT_ALLOWED;
                    LOG.warn("wrong method {} {} {}", new Object[]{request.method(), request.uri(), statusCode});
                }
                methods = Sets.newTreeSet((Iterable)methods);
                methods.add("OPTIONS");
                this.ongoingRequest.reply((Response<ByteString>)Response.forStatus((StatusType)statusCode).withHeader("Allow", Joiner.on((String)", ").join((Iterable)methods)));
            }
            return;
        }
        matchContinuation.accept(this.ongoingRequest, (RuleMatch<Endpoint>)match.get());
    }
}

