/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.request;

import com.spotify.apollo.RequestContext;
import com.spotify.apollo.dispatch.Endpoint;
import com.spotify.apollo.meta.IncomingCallsGatherer;
import com.spotify.apollo.request.EndpointRunnableFactory;
import com.spotify.apollo.request.OngoingRequest;
import com.spotify.apollo.request.RequestTracker;
import com.spotify.apollo.request.TrackedOngoingRequestImpl;

class TrackingEndpointRunnableFactory
implements EndpointRunnableFactory {
    private final EndpointRunnableFactory delegate;
    private final IncomingCallsGatherer incomingCallsGatherer;
    private final RequestTracker requestTracker;

    TrackingEndpointRunnableFactory(EndpointRunnableFactory delegate, IncomingCallsGatherer incomingCallsGatherer, RequestTracker requestTracker) {
        this.delegate = delegate;
        this.incomingCallsGatherer = incomingCallsGatherer;
        this.requestTracker = requestTracker;
    }

    @Override
    public Runnable create(OngoingRequest ongoingRequest, RequestContext requestContext, Endpoint endpoint) {
        this.incomingCallsGatherer.gatherIncomingCall(ongoingRequest, endpoint);
        TrackedOngoingRequestImpl trackedRequest = new TrackedOngoingRequestImpl(ongoingRequest, this.requestTracker);
        return this.delegate.create(trackedRequest, requestContext, endpoint);
    }
}

