/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.route;

import com.spotify.apollo.Request;
import com.spotify.apollo.Response;
import com.spotify.apollo.Serializer;
import com.spotify.apollo.Status;
import com.spotify.apollo.StatusType;
import com.spotify.apollo.route.AsyncHandler;
import com.spotify.apollo.route.Middleware;
import com.spotify.apollo.serialization.AutoSerializer;
import java.util.Optional;
import okio.ByteString;

public final class Middlewares {
    private static final String CONTENT_TYPE = "Content-Type";

    private Middlewares() {
    }

    public static <T> AsyncHandler<Response<ByteString>> autoSerialize(AsyncHandler<T> inner) {
        return (AsyncHandler)Middlewares.serialize(new AutoSerializer()).apply(inner);
    }

    public static AsyncHandler<Response<ByteString>> httpPayloadSemantics(AsyncHandler<Response<ByteString>> inner) {
        return inner.flatMapSync(resp -> ctx -> Middlewares.applyHttpPayloadSemantics(ctx.request(), (Response<ByteString>)resp));
    }

    public static Middleware<AsyncHandler<?>, AsyncHandler<Response<?>>> replyContentType(String contentType) {
        return inner -> inner.map(Middlewares::ensureResponse).map(response -> response.withHeader(CONTENT_TYPE, contentType));
    }

    public static Middleware<AsyncHandler<?>, AsyncHandler<Response<ByteString>>> serialize(Serializer serializer) {
        return inner -> inner.map(Middlewares::ensureResponse).flatMapSync(resp -> ctx -> Middlewares.serializePayload(serializer, ctx.request(), resp));
    }

    public static Middleware<AsyncHandler<?>, AsyncHandler<Response<ByteString>>> apolloDefaults() {
        return Middlewares.serialize(new AutoSerializer()).and(Middlewares::httpPayloadSemantics);
    }

    private static Response<ByteString> applyHttpPayloadSemantics(Request request, Response<ByteString> response) {
        Response result = response;
        Optional payload = response.payload();
        if (Middlewares.setContentLengthForStatus(response.status())) {
            int payloadSize = payload.isPresent() ? ((ByteString)payload.get()).size() : 0;
            result = result.withHeader("Content-Length", String.valueOf(payloadSize));
        }
        if (!Middlewares.setPayloadForMethod(request.method()) || !Middlewares.setPayloadForStatus(response.status())) {
            result = result.withPayload(null);
        }
        return result;
    }

    private static boolean setPayloadForStatus(StatusType statusType) {
        return statusType.code() != Status.NOT_MODIFIED.code() && statusType.code() != Status.NO_CONTENT.code() && statusType.family() != StatusType.Family.INFORMATIONAL;
    }

    private static boolean setPayloadForMethod(String method) {
        return !"HEAD".equalsIgnoreCase(method);
    }

    private static boolean setContentLengthForStatus(StatusType statusType) {
        return Middlewares.setPayloadForStatus(statusType);
    }

    private static <T> Response<ByteString> serializePayload(Serializer serializer, Request request, Response<T> response) {
        if (!response.payload().isPresent()) {
            return response;
        }
        Object payloadObject = response.payload().get();
        Serializer.Payload payload = serializer.serialize(request, payloadObject);
        if (payload.contentType().isPresent()) {
            response = response.withHeader(CONTENT_TYPE, (String)payload.contentType().get());
        }
        return response.withPayload((Object)payload.byteString());
    }

    private static <T> Response<T> ensureResponse(T t) {
        if (t instanceof Response) {
            return (Response)t;
        }
        return Response.forPayload(t);
    }
}

