/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.route;

import com.spotify.apollo.Response;
import com.spotify.apollo.dispatch.Endpoint;
import com.spotify.apollo.route.AsyncHandler;
import com.spotify.apollo.route.Route;
import com.spotify.apollo.route.RouteEndpoint;
import com.spotify.apollo.route.Rule;
import java.util.regex.Pattern;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RouteRuleBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(RouteRuleBuilder.class);
    private static final Pattern STRIP_SCHEME_AUTH = Pattern.compile("[a-zA-Z][a-zA-Z0-9+.-]*://[^/]+");

    private RouteRuleBuilder() {
    }

    static Rule<Endpoint> toRule(Route<? extends AsyncHandler<Response<ByteString>>> route) {
        String uri = route.uri();
        String requestMethod = route.method();
        String relativeUri = STRIP_SCHEME_AUTH.matcher(uri).replaceFirst("");
        LOG.debug("Found Route with method: {}, uri: {}", (Object)requestMethod, (Object)relativeUri);
        RouteEndpoint endpoint = new RouteEndpoint(route);
        Rule rule = Rule.fromUri((String)relativeUri, (String)requestMethod, (Object)endpoint);
        return rule;
    }
}

