/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo;

import com.spotify.apollo.AutoValue_RequestValue;
import com.spotify.apollo.QueryStringDecoder;
import com.spotify.apollo.Request;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import okio.ByteString;

abstract class RequestValue
implements Request {
    public static final String GET = "GET";

    RequestValue() {
    }

    public static Request create(String uri) {
        return RequestValue.create(uri, GET);
    }

    public static Request create(String uri, String method) {
        return RequestValue.create(method, uri, RequestValue.parseParameters(uri), Collections.emptyMap(), Optional.empty(), Optional.empty());
    }

    private static Request create(String method, String uri, Map<String, List<String>> parameters, Map<String, String> headers, Optional<String> service, Optional<ByteString> payload) {
        return new AutoValue_RequestValue(method, uri, parameters, headers, service, payload);
    }

    @Override
    public Request withService(String service) {
        return RequestValue.create(this.method(), this.uri(), this.parameters(), this.headers(), Optional.of(service), this.payload());
    }

    @Override
    public Request withHeader(String name, String value) {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>(this.headers());
        headers.put(name, value);
        return RequestValue.create(this.method(), this.uri(), this.parameters(), headers, this.service(), this.payload());
    }

    @Override
    public Request withPayload(ByteString payload) {
        return RequestValue.create(this.method(), this.uri(), this.parameters(), this.headers(), this.service(), Optional.of(payload));
    }

    private static Map<String, List<String>> parseParameters(String uri) {
        return new QueryStringDecoder(uri).parameters();
    }
}

