/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo;

import com.spotify.apollo.ResponseImpl;
import com.spotify.apollo.StatusType;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

public interface Response<T> {
    public StatusType status();

    public Map<String, String> headers();

    public Optional<T> payload();

    public Response<T> withHeader(String var1, String var2);

    public <P> Response<P> withPayload(@Nullable P var1);

    public static <T> Response<T> ok() {
        return ResponseImpl.OK;
    }

    public static <T> Response<T> forStatus(StatusType statusCode) {
        return ResponseImpl.create(statusCode);
    }

    public static <T> Response<T> forPayload(T payload) {
        return ResponseImpl.create(payload);
    }

    public static <T> Response<T> of(StatusType statusCode, T payload) {
        return ResponseImpl.create(statusCode, payload);
    }
}

