/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo;

import com.google.common.collect.ImmutableMap;
import com.spotify.apollo.AutoValue_ResponseImpl;
import com.spotify.apollo.Response;
import com.spotify.apollo.Status;
import com.spotify.apollo.StatusType;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

abstract class ResponseImpl<T>
implements Response<T> {
    static final Response<?> OK = ResponseImpl.createInternal(Status.OK, Optional.empty());

    ResponseImpl() {
    }

    @Override
    public Response<T> withHeader(String header, String value) {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        headers.putAll(this.headers());
        headers.put(header, value);
        return ResponseImpl.createInternal(this.status(), (Map<String, String>)ImmutableMap.copyOf(headers), this.payload());
    }

    @Override
    public <P> Response<P> withPayload(@Nullable P newPayload) {
        return ResponseImpl.createInternal(this.status(), this.headers(), Optional.ofNullable(newPayload));
    }

    static <T> Response<T> create(StatusType statusCode) {
        Objects.requireNonNull(statusCode);
        return statusCode == Status.OK ? OK : ResponseImpl.createInternal(statusCode, Optional.empty());
    }

    static <T> Response<T> create(StatusType statusCode, T payload) {
        Objects.requireNonNull(statusCode);
        return ResponseImpl.createInternal(statusCode, Optional.of(payload));
    }

    static <T> Response<T> create(T payload) {
        return ResponseImpl.createInternal(Status.OK, Optional.of(payload));
    }

    private static <T> Response<T> createInternal(StatusType statusCode, Optional<T> payload) {
        return ResponseImpl.createInternal(statusCode, Collections.emptyMap(), payload);
    }

    private static <T> Response<T> createInternal(StatusType statusCode, Map<String, String> headers, Optional<T> payload) {
        return new AutoValue_ResponseImpl<T>(statusCode, headers, payload);
    }
}

