/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.route;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.spotify.apollo.route.AsyncHandler;
import com.spotify.apollo.route.ListenableFutureHandler;
import com.spotify.apollo.route.SyncHandler;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

@FunctionalInterface
public interface Middleware<H, T>
extends Function<H, T> {
    default public <K> Middleware<H, K> and(Middleware<? super T, ? extends K> other) {
        return h -> other.apply((Object)this.apply(h));
    }

    public static <T> AsyncHandler<T> syncToAsync(SyncHandler<T> handler) {
        return requestContext -> CompletableFuture.completedFuture(handler.invoke(requestContext));
    }

    public static <T> AsyncHandler<T> guavaToAsync(ListenableFutureHandler<T> listenableFutureHandler) {
        return requestContext -> {
            final CompletableFuture future = new CompletableFuture();
            Futures.addCallback(listenableFutureHandler.invoke(requestContext), (FutureCallback)new FutureCallback<T>(){

                public void onSuccess(T result) {
                    future.complete(result);
                }

                public void onFailure(Throwable t) {
                    future.completeExceptionally(t);
                }
            });
            return future;
        };
    }
}

