/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.route;

import com.spotify.apollo.route.AsyncHandler;
import com.spotify.apollo.route.AutoValue_RouteImpl;
import com.spotify.apollo.route.AutoValue_Route_DocString;
import com.spotify.apollo.route.ListenableFutureHandler;
import com.spotify.apollo.route.Middleware;
import com.spotify.apollo.route.SyncHandler;
import java.util.Optional;
import javax.annotation.Nullable;

public interface Route<H> {
    public String method();

    public String uri();

    public H handler();

    public Optional<DocString> docString();

    default public <K> Route<K> withHandler(K handler) {
        return this.copy(this.method(), this.uri(), handler, this.docString().orElse(null));
    }

    default public Route<H> withDocString(String summary, String description) {
        return this.copy(this.method(), this.uri(), this.handler(), DocString.doc(summary, description));
    }

    default public <K> Route<K> withMiddleware(Middleware<? super H, ? extends K> middleware) {
        return this.copy(this.method(), this.uri(), middleware.apply(this.handler()), this.docString().orElse(null));
    }

    default public Route<H> withPrefix(String prefix) {
        return this.copy(this.method(), prefix + this.uri(), this.handler(), this.docString().orElse(null));
    }

    public <K> Route<K> copy(String var1, String var2, K var3, @Nullable DocString var4);

    public static <H> Route<H> create(String method, String uri, H handler, @Nullable DocString docString) {
        return new AutoValue_RouteImpl<H>(method, uri, handler, Optional.ofNullable(docString));
    }

    public static <H> Route<H> create(String method, String uri, H handler) {
        return Route.create(method, uri, handler, null);
    }

    public static <H, K> Route<K> with(Middleware<? super H, ? extends K> m, String method, String uri, H handler) {
        return Route.create(method, uri, m.apply(handler));
    }

    public static <T> Route<AsyncHandler<T>> async(String method, String uri, AsyncHandler<T> handler) {
        return Route.create(method, uri, handler);
    }

    public static <T> Route<AsyncHandler<T>> sync(String method, String uri, SyncHandler<T> handler) {
        return Route.create(method, uri, handler).withMiddleware(Middleware::syncToAsync);
    }

    public static <T> Route<AsyncHandler<T>> future(String method, String uri, ListenableFutureHandler<T> handler) {
        return Route.create(method, uri, handler).withMiddleware(Middleware::guavaToAsync);
    }

    public static abstract class DocString {
        public abstract String summary();

        public abstract String description();

        public static DocString doc(String summary, String description) {
            return new AutoValue_Route_DocString(summary, description);
        }
    }
}

