/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo;

import com.spotify.apollo.RequestValue;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import okio.ByteString;

public interface Request {
    public String method();

    public String uri();

    public Map<String, List<String>> parameters();

    default public Optional<String> parameter(String parameter) {
        List<String> values = this.parameters().get(parameter);
        if (values != null) {
            return Optional.ofNullable(values.get(0));
        }
        return Optional.empty();
    }

    public Map<String, String> headers();

    default public Optional<String> header(String name) {
        return Optional.ofNullable(this.headers().get(name));
    }

    public Optional<String> service();

    public Optional<ByteString> payload();

    default public Optional<Duration> ttl() {
        return Optional.empty();
    }

    public Request withUri(String var1);

    public Request withService(String var1);

    public Request withHeader(String var1, String var2);

    public Request withHeaders(Map<String, String> var1);

    public Request clearHeaders();

    public Request withPayload(ByteString var1);

    default public Request withTtl(Duration ttl) {
        throw new UnsupportedOperationException();
    }

    public static Request forUri(String uri, String method) {
        return RequestValue.create(uri, method);
    }

    public static Request forUri(String uri) {
        return RequestValue.create(uri);
    }
}

