/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo;

import com.google.common.collect.ImmutableMap;
import com.spotify.apollo.AutoValue_RequestValue;
import com.spotify.apollo.QueryStringDecoder;
import com.spotify.apollo.Request;
import java.time.Duration;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import okio.ByteString;

abstract class RequestValue
implements Request {
    public static final String GET = "GET";

    RequestValue() {
    }

    public static Request create(String uri) {
        return RequestValue.create(uri, GET);
    }

    public static Request create(String uri, String method) {
        return RequestValue.create(method, uri, RequestValue.parseParameters(uri), Collections.emptyMap(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    private static Request create(String method, String uri, Map<String, List<String>> parameters, Map<String, String> headers, Optional<String> service, Optional<ByteString> payload, Optional<Duration> ttl) {
        return new AutoValue_RequestValue(method, uri, (Map<String, List<String>>)ImmutableMap.copyOf(parameters), (Map<String, String>)ImmutableMap.copyOf(headers), service, payload, ttl);
    }

    @Override
    public abstract Optional<Duration> ttl();

    @Override
    public Request withUri(String uri) {
        return RequestValue.create(this.method(), uri, this.parameters(), this.headers(), this.service(), this.payload(), this.ttl());
    }

    @Override
    public Request withService(String service) {
        return RequestValue.create(this.method(), this.uri(), this.parameters(), this.headers(), Optional.of(service), this.payload(), this.ttl());
    }

    @Override
    public Request withHeader(String name, String value) {
        return this.withHeaders((Map<String, String>)ImmutableMap.of((Object)name, (Object)value));
    }

    @Override
    public Request withHeaders(Map<String, String> additionalHeaders) {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>(this.headers());
        headers.putAll(additionalHeaders);
        return RequestValue.create(this.method(), this.uri(), this.parameters(), headers, this.service(), this.payload(), this.ttl());
    }

    @Override
    public Request clearHeaders() {
        return RequestValue.create(this.method(), this.uri(), this.parameters(), Collections.emptyMap(), this.service(), this.payload(), this.ttl());
    }

    @Override
    public Request withPayload(ByteString payload) {
        return RequestValue.create(this.method(), this.uri(), this.parameters(), this.headers(), this.service(), Optional.of(payload), this.ttl());
    }

    @Override
    public Request withTtl(Duration duration) {
        return RequestValue.create(this.method(), this.uri(), this.parameters(), this.headers(), this.service(), this.payload(), Optional.of(duration));
    }

    private static Map<String, List<String>> parseParameters(String uri) {
        return new QueryStringDecoder(uri).parameters();
    }
}

