/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo;

import com.google.common.base.CharMatcher;
import com.spotify.apollo.AutoValue_Status_WithReasonPhrase;
import com.spotify.apollo.StatusType;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public enum Status implements StatusType
{
    OK(200, "OK"),
    CREATED(201, "Created"),
    ACCEPTED(202, "Accepted"),
    NO_CONTENT(204, "No Content"),
    RESET_CONTENT(205, "Reset Content"),
    PARTIAL_CONTENT(206, "Partial Content"),
    MOVED_PERMANENTLY(301, "Moved Permanently"),
    FOUND(302, "Found"),
    SEE_OTHER(303, "See Other"),
    NOT_MODIFIED(304, "Not Modified"),
    USE_PROXY(305, "Use Proxy"),
    TEMPORARY_REDIRECT(307, "Temporary Redirect"),
    BAD_REQUEST(400, "Bad Request"),
    UNAUTHORIZED(401, "Unauthorized"),
    PAYMENT_REQUIRED(402, "Payment Required"),
    FORBIDDEN(403, "Forbidden"),
    NOT_FOUND(404, "Not Found"),
    METHOD_NOT_ALLOWED(405, "Method Not Allowed"),
    NOT_ACCEPTABLE(406, "Not Acceptable"),
    PROXY_AUTHENTICATION_REQUIRED(407, "Proxy Authentication Required"),
    REQUEST_TIMEOUT(408, "Request Timeout"),
    CONFLICT(409, "Conflict"),
    GONE(410, "Gone"),
    LENGTH_REQUIRED(411, "Length Required"),
    PRECONDITION_FAILED(412, "Precondition Failed"),
    REQUEST_ENTITY_TOO_LARGE(413, "Request Entity Too Large"),
    REQUEST_URI_TOO_LONG(414, "Request-URI Too Long"),
    UNSUPPORTED_MEDIA_TYPE(415, "Unsupported Media Type"),
    REQUESTED_RANGE_NOT_SATISFIABLE(416, "Requested Range Not Satisfiable"),
    EXPECTATION_FAILED(417, "Expectation Failed"),
    IM_A_TEAPOT(418, "I'm a Teapot"),
    UNPROCESSABLE_ENTITY(422, "Unprocessable Entity"),
    INTERNAL_SERVER_ERROR(500, "Internal Server Error"),
    NOT_IMPLEMENTED(501, "Not Implemented"),
    BAD_GATEWAY(502, "Bad Gateway"),
    SERVICE_UNAVAILABLE(503, "Service Unavailable"),
    GATEWAY_TIMEOUT(504, "Gateway Timeout");

    private static final CharMatcher ILLEGAL_REASONPHRASE_CHARS;
    private static final Map<Integer, Status> EXISTING;
    private final int statusCode;
    private final String reasonPhrase;

    private Status(int statusCode, String reasonPhrase) {
        this.statusCode = statusCode;
        this.reasonPhrase = reasonPhrase;
    }

    @Override
    public int code() {
        return this.statusCode;
    }

    @Override
    public String reasonPhrase() {
        return this.reasonPhrase;
    }

    @Override
    public StatusType.Family family() {
        return StatusType.Family.familyOf(this.statusCode);
    }

    @Override
    public StatusType withReasonPhrase(String reasonPhrase) {
        return WithReasonPhrase.create(this.code(), reasonPhrase);
    }

    public static Status existingFromStatusCode(int statusCode) {
        return Status.findExistingFromStatusCode(statusCode).orElseThrow(() -> new IllegalArgumentException(MessageFormat.format("No status with status code {0} found", statusCode)));
    }

    public static Optional<Status> findExistingFromStatusCode(int statusCode) {
        return Optional.ofNullable(EXISTING.get(statusCode));
    }

    public static StatusType createForCode(int statusCode) {
        Status existingStatus = EXISTING.get(statusCode);
        if (existingStatus != null) {
            return existingStatus;
        }
        return WithReasonPhrase.create(statusCode, "");
    }

    static {
        ILLEGAL_REASONPHRASE_CHARS = CharMatcher.anyOf((CharSequence)"\n\r").or(CharMatcher.inRange((char)'\u0000', (char)'\u001f')).or(CharMatcher.is((char)'\u007f'));
        EXISTING = new LinkedHashMap<Integer, Status>();
        for (Status status : Status.values()) {
            EXISTING.put(status.statusCode, status);
        }
    }

    public static abstract class WithReasonPhrase
    implements StatusType {
        @Override
        public abstract int code();

        @Override
        public abstract String reasonPhrase();

        @Override
        public abstract StatusType.Family family();

        public static WithReasonPhrase create(int statusCode, String reasonPhrase) {
            String safeReasonPhrase = ILLEGAL_REASONPHRASE_CHARS.replaceFrom((CharSequence)reasonPhrase, ' ');
            return new AutoValue_Status_WithReasonPhrase(statusCode, safeReasonPhrase, StatusType.Family.familyOf(statusCode));
        }

        @Override
        public StatusType withReasonPhrase(String reasonPhrase) {
            return WithReasonPhrase.create(this.code(), reasonPhrase);
        }
    }
}

