/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.core;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.spotify.apollo.module.ApolloModule;
import com.typesafe.config.Config;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public interface Service {
    public String getServiceName();

    public Instance start(String ... var1) throws IOException;

    @VisibleForTesting
    public Instance start(String[] var1, Map<String, String> var2) throws IOException;

    @VisibleForTesting
    public Instance start(String[] var1, Config var2) throws IOException;

    public static interface Signaller {
        public void signalShutdown();
    }

    public static interface Instance
    extends Closeable {
        public Service getService();

        public Config getConfig();

        public ListeningExecutorService getExecutorService();

        public ListeningScheduledExecutorService getScheduledExecutorService();

        public Closer getCloser();

        public ImmutableList<String> getUnprocessedArgs();

        public Signaller getSignaller();

        public <T> T resolve(Class<T> var1);

        public void waitForShutdown() throws InterruptedException;

        public boolean isShutdown();
    }

    public static interface Builder {
        public Builder withModule(ApolloModule var1);

        public Builder usingModuleDiscovery(boolean var1);

        public Builder withShutdownInterrupt(boolean var1);

        public Builder withCliHelp(boolean var1);

        public Builder withEnvVarPrefix(String var1);

        public Builder withWatchdogTimeout(long var1, TimeUnit var3);

        @VisibleForTesting
        public Builder withRuntime(Runtime var1);

        public Service build();
    }
}

