/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.environment;

import com.spotify.apollo.environment.ConfigUtil;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.Objects;
import javax.inject.Inject;

public class ApolloConfig {
    private final Config apolloNode;

    @Inject
    public ApolloConfig(Config configNode) {
        Config root = Objects.requireNonNull(configNode);
        this.apolloNode = root.hasPath("apollo") ? root.getConfig("apollo") : ConfigFactory.empty();
    }

    public String backend() {
        return ConfigUtil.either(ConfigUtil.optionalString(this.apolloNode, "domain"), ConfigUtil.optionalString(this.apolloNode, "backend")).orElse("");
    }

    public boolean enableIncomingRequestLogging() {
        return ConfigUtil.optionalBoolean(this.apolloNode, "logIncomingRequests").orElse(true);
    }

    public boolean enableMetaApi() {
        return ConfigUtil.optionalBoolean(this.apolloNode, "metaApi").orElse(true);
    }
}

