/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.environment;

import com.google.common.collect.Iterables;
import com.google.common.io.Closer;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.multibindings.Multibinder;
import com.spotify.apollo.AppInit;
import com.spotify.apollo.Environment;
import com.spotify.apollo.core.Service;
import com.spotify.apollo.environment.ApolloConfig;
import com.spotify.apollo.environment.ApolloEnvironment;
import com.spotify.apollo.environment.ClientDecorator;
import com.spotify.apollo.environment.EndpointRunnableFactoryDecorator;
import com.spotify.apollo.environment.EnvironmentFactory;
import com.spotify.apollo.environment.EnvironmentModule;
import com.spotify.apollo.environment.IncomingRequestAwareClient;
import com.spotify.apollo.environment.MetaModule;
import com.spotify.apollo.environment.RequestRunnableFactoryDecorator;
import com.spotify.apollo.meta.ApplicationOrMetaRouter;
import com.spotify.apollo.meta.IncomingCallsGatherer;
import com.spotify.apollo.meta.MetaApplication;
import com.spotify.apollo.meta.MetaInfoTracker;
import com.spotify.apollo.meta.model.MetaGatherer;
import com.spotify.apollo.module.AbstractApolloModule;
import com.spotify.apollo.request.EndpointRunnableFactory;
import com.spotify.apollo.request.Handlers;
import com.spotify.apollo.request.RequestHandler;
import com.spotify.apollo.request.RequestRunnableFactory;
import com.spotify.apollo.request.RequestTracker;
import com.spotify.apollo.route.ApplicationRouter;
import com.spotify.apollo.route.Routers;
import com.typesafe.config.Config;
import java.io.Closeable;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApolloEnvironmentModule
extends AbstractApolloModule {
    private static final Logger LOG = LoggerFactory.getLogger(ApolloEnvironmentModule.class);

    public static ApolloEnvironmentModule create() {
        return new ApolloEnvironmentModule();
    }

    public static ApolloEnvironment environment(Service.Instance instance) {
        return (ApolloEnvironment)instance.resolve(ApolloEnvironment.class);
    }

    protected void configure() {
        Multibinder.newSetBinder((Binder)this.binder(), ClientDecorator.class);
        Multibinder.newSetBinder((Binder)this.binder(), RequestRunnableFactoryDecorator.class);
        Multibinder.newSetBinder((Binder)this.binder(), EndpointRunnableFactoryDecorator.class);
        this.bind(ApolloConfig.class).in(Singleton.class);
        this.bind(ApolloEnvironment.class).to(ApolloEnvironmentImpl.class).in(Singleton.class);
        this.install((Module)new MetaModule());
        this.install((Module)new EnvironmentModule());
    }

    public String getId() {
        return "apollo-env";
    }

    static <R> R foldDecorators(R init, Iterable<? extends Function<R, R>> decorators) {
        R fold = init;
        for (Function<R, R> decorator : decorators) {
            fold = decorator.apply(fold);
        }
        return fold;
    }

    private static class ApolloEnvironmentImpl
    implements ApolloEnvironment {
        private final Closer closer;
        private final Config configNode;
        private final ApolloConfig apolloConfig;
        private final Environment environment;
        private final IncomingRequestAwareClient incomingRequestAwareClient;
        private final EnvironmentFactory.RoutingContext routingContext;
        private final MetaInfoTracker metaInfoTracker;
        private final Set<RequestRunnableFactoryDecorator> rrfDecorators;
        private final Set<EndpointRunnableFactoryDecorator> erfDecorators;

        @Inject
        private ApolloEnvironmentImpl(Closer closer, Config configNode, Environment environment, EnvironmentFactory.RoutingContext routingContext, IncomingRequestAwareClient incomingRequestAwareClient, MetaInfoTracker metaInfoTracker, Set<RequestRunnableFactoryDecorator> rrfDecorators, Set<EndpointRunnableFactoryDecorator> erfDecorators, ApolloConfig apolloConfig) {
            this.closer = closer;
            this.configNode = configNode;
            this.environment = environment;
            this.routingContext = routingContext;
            this.incomingRequestAwareClient = incomingRequestAwareClient;
            this.metaInfoTracker = metaInfoTracker;
            this.rrfDecorators = rrfDecorators;
            this.erfDecorators = erfDecorators;
            this.apolloConfig = apolloConfig;
        }

        @Override
        public Environment environment() {
            return this.environment;
        }

        @Override
        public RequestHandler initialize(AppInit appInit) {
            appInit.create(this.environment);
            return this.createRequestHandler();
        }

        private RequestHandler createRequestHandler() {
            Object[] all = Iterables.toArray((Iterable)this.routingContext.endpointObjects(), Object.class);
            ApplicationRouter applicationRouter = Routers.newRouterFromInspecting((Object[])all);
            MetaGatherer gatherer = this.metaInfoTracker.getGatherer();
            this.metaInfoTracker.gatherEndpoints(applicationRouter.getRuleTargets());
            ApplicationRouter metaRouter = Routers.newRouterFromInspecting((Object[])new Object[]{new MetaApplication(gatherer)});
            ApplicationRouter endpointApplicationOrMetaRouter = this.apolloConfig.enableMetaApi() ? new ApplicationOrMetaRouter(applicationRouter, metaRouter) : applicationRouter;
            RequestRunnableFactory baseRequestRunnableFactory = Handlers.requestRunnableFactory((ApplicationRouter)endpointApplicationOrMetaRouter);
            EndpointRunnableFactory baseEndpointRunnableFactory = Handlers.endpointRunnableFactory();
            RequestRunnableFactory decoratedRequestRunnableFactory = ApolloEnvironmentModule.foldDecorators(baseRequestRunnableFactory, this.rrfDecorators);
            EndpointRunnableFactory decoratedEndpointRunnableFactory = ApolloEnvironmentModule.foldDecorators(baseEndpointRunnableFactory, this.erfDecorators);
            RequestTracker requestTracker = new RequestTracker();
            RequestHandler requestHandler = Handlers.requestHandler((RequestRunnableFactory)decoratedRequestRunnableFactory, (EndpointRunnableFactory)Handlers.withTracking((EndpointRunnableFactory)decoratedEndpointRunnableFactory, (IncomingCallsGatherer)this.metaInfoTracker.incomingCallsGatherer(), (RequestTracker)requestTracker), (IncomingRequestAwareClient)this.incomingRequestAwareClient);
            this.closer.register((Closeable)requestTracker);
            this.closer.register(() -> LOG.info("Shutting down Apollo instance"));
            return requestHandler;
        }
    }
}

