/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.environment;

import com.google.common.io.Closer;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.name.Named;
import com.spotify.apollo.Client;
import com.spotify.apollo.Environment;
import com.spotify.apollo.environment.ApolloConfig;
import com.spotify.apollo.environment.ApolloEnvironmentModule;
import com.spotify.apollo.environment.ClientDecorator;
import com.spotify.apollo.environment.EnvironmentFactory;
import com.spotify.apollo.environment.EnvironmentFactoryBuilder;
import com.spotify.apollo.environment.IncomingRequestAwareClient;
import com.spotify.apollo.environment.NoopClient;
import com.spotify.apollo.environment.ServiceSettingClient;
import com.spotify.apollo.meta.MetaInfoTracker;
import com.spotify.apollo.meta.OutgoingCallsGatheringClient;
import com.typesafe.config.Config;
import java.util.Set;
import javax.inject.Singleton;

class EnvironmentModule
extends AbstractModule {
    EnvironmentModule() {
    }

    @Provides
    @Singleton
    IncomingRequestAwareClient incomingRequestAwareClient(@Named(value="service-name") String serviceName, Set<ClientDecorator> clientDecorators, MetaInfoTracker metaInfoTracker) {
        IncomingRequestAwareClient clientStack = ApolloEnvironmentModule.foldDecorators(new NoopClient(), clientDecorators);
        ServiceSettingClient serviceSettingClient = new ServiceSettingClient(serviceName, clientStack);
        return new OutgoingCallsGatheringClient(metaInfoTracker.outgoingCallsGatherer(), (IncomingRequestAwareClient)serviceSettingClient);
    }

    @Provides
    @Singleton
    EnvironmentFactory environmentFactory(Config configNode, ApolloConfig apolloConfig, Closer closer, Injector injector, IncomingRequestAwareClient incomingRequestAwareClient) {
        String backend = apolloConfig.backend();
        Client unawareClient = incomingRequestAwareClient.asUnawareClient();
        return EnvironmentFactoryBuilder.newBuilder((String)backend, (Client)unawareClient, (Closer)closer, arg_0 -> ((Injector)injector).getInstance(arg_0)).withStaticConfig(configNode).build();
    }

    @Provides
    @Singleton
    EnvironmentFactory.RoutingContext routingContext(EnvironmentFactory environmentFactory) {
        return environmentFactory.createRoutingContext();
    }

    @Provides
    @Singleton
    Environment environment(@Named(value="service-name") String serviceName, EnvironmentFactory environmentFactory, EnvironmentFactory.RoutingContext routingContext) {
        return environmentFactory.create(serviceName, routingContext);
    }

    protected void configure() {
    }
}

