/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.environment;

import com.spotify.apollo.environment.ConfigUtil;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.Objects;
import javax.inject.Inject;

public class ApolloConfig {
    private final Config root;
    private final Config apolloNode;

    @Inject
    public ApolloConfig(Config configNode) {
        this.root = Objects.requireNonNull(configNode);
        this.apolloNode = this.root.hasPath("apollo") ? this.root.getConfig("apollo") : ConfigFactory.empty();
    }

    public String backend() {
        return ConfigUtil.either(ConfigUtil.either(ConfigUtil.optionalString(this.apolloNode, "domain"), ConfigUtil.optionalString(this.apolloNode, "backend")), ConfigUtil.optionalString(this.root, "domain")).orElse("");
    }

    public boolean enableIncomingRequestLogging() {
        return ConfigUtil.optionalBoolean(this.apolloNode, "logIncomingRequests").orElse(true);
    }

    public boolean enableOutgoingRequestLogging() {
        return ConfigUtil.optionalBoolean(this.apolloNode, "logOutgoingRequests").orElse(true);
    }

    public boolean enableMetaApi() {
        return ConfigUtil.optionalBoolean(this.apolloNode, "metaApi").orElse(true);
    }
}

