/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.environment;

import com.spotify.apollo.Request;
import com.spotify.apollo.Response;
import com.spotify.apollo.environment.IncomingRequestAwareClient;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import okio.ByteString;

class ServiceSettingClient
implements IncomingRequestAwareClient {
    private final String serviceName;
    private final IncomingRequestAwareClient delegate;

    ServiceSettingClient(String serviceName, IncomingRequestAwareClient delegate) {
        this.serviceName = Objects.requireNonNull(serviceName);
        this.delegate = Objects.requireNonNull(delegate);
    }

    public CompletionStage<Response<ByteString>> send(Request request, Optional<Request> incoming) {
        Request withService = !request.service().isPresent() ? request.withService(this.serviceName) : request;
        return this.delegate.send(withService, incoming);
    }
}

