/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.concurrent;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public final class Util {
    private Util() {
    }

    public static <T> CompletionStage<T> asStage(ListenableFuture<T> future) {
        final CompletableFuture completableFuture = new CompletableFuture();
        Futures.addCallback(future, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(T result) {
                completableFuture.complete(result);
            }

            public void onFailure(Throwable t) {
                completableFuture.completeExceptionally(t);
            }
        });
        return completableFuture;
    }

    public static <T> ListenableFuture<T> asFuture(CompletionStage<T> stage) {
        SettableFuture future = SettableFuture.create();
        stage.whenComplete((result, throwable) -> {
            if (throwable != null) {
                future.setException(throwable);
            } else {
                future.set(result);
            }
        });
        return future;
    }
}

