/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.route;

import com.google.common.base.Throwables;
import com.spotify.apollo.Response;
import com.spotify.apollo.route.AsyncHandler;
import com.spotify.apollo.route.Middleware;
import com.spotify.apollo.route.SyncHandler;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.StringWriter;
import java.io.Writer;
import okio.ByteString;

public class HtmlSerializerMiddlewares {
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String HTML = "text/html; charset=UTF8";
    private static final Configuration configuration = new Configuration(Configuration.VERSION_2_3_22);

    private HtmlSerializerMiddlewares() {
    }

    public static <T> ByteString serialize(String templateName, T object) {
        StringWriter templateResults = new StringWriter();
        try {
            Template template = configuration.getTemplate(templateName);
            template.process(object, (Writer)templateResults);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        return ByteString.encodeUtf8((String)templateResults.toString());
    }

    public static <T> Middleware<AsyncHandler<T>, AsyncHandler<Response<ByteString>>> htmlSerialize(String templateName) {
        return handler -> requestContext -> handler.invoke(requestContext).thenApply(result -> Response.forPayload((Object)HtmlSerializerMiddlewares.serialize(templateName, result)).withHeader(CONTENT_TYPE, HTML));
    }

    public static <T> Middleware<AsyncHandler<Response<T>>, AsyncHandler<Response<ByteString>>> htmlSerializeResponse(String templateName) {
        return handler -> requestContext -> handler.invoke(requestContext).thenApply(response -> response.withPayload((Object)HtmlSerializerMiddlewares.serialize(templateName, response.payload().orElse(null))).withHeader(CONTENT_TYPE, HTML));
    }

    public static <T> Middleware<SyncHandler<T>, AsyncHandler<Response<ByteString>>> htmlSerializeSync(String templateName) {
        Middleware syncToAsync = Middleware::syncToAsync;
        return syncToAsync.and(HtmlSerializerMiddlewares.htmlSerialize(templateName));
    }

    public static <T> Middleware<SyncHandler<Response<T>>, AsyncHandler<Response<ByteString>>> htmlSerializeResponseSync(String templateName) {
        Middleware syncToAsync = Middleware::syncToAsync;
        return syncToAsync.and(HtmlSerializerMiddlewares.htmlSerializeResponse(templateName));
    }

    static {
        configuration.setClassForTemplateLoading(HtmlSerializerMiddlewares.class, "/");
        configuration.setDefaultEncoding("UTF-8");
        configuration.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        configuration.setIncompatibleImprovements(Configuration.VERSION_2_3_22);
    }
}

