/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.route;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Throwables;
import com.spotify.apollo.Response;
import com.spotify.apollo.route.AsyncHandler;
import com.spotify.apollo.route.Middleware;
import com.spotify.apollo.route.SyncHandler;
import okio.ByteString;

public class JsonSerializerMiddlewares {
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String JSON = "application/json; charset=UTF8";

    private JsonSerializerMiddlewares() {
    }

    private static <T> ByteString serialize(ObjectWriter objectWriter, T object) {
        try {
            return ByteString.of((byte[])objectWriter.writeValueAsBytes(object));
        }
        catch (JsonProcessingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static <T> Middleware<AsyncHandler<T>, AsyncHandler<Response<ByteString>>> jsonSerialize(ObjectWriter objectWriter) {
        return handler -> requestContext -> handler.invoke(requestContext).thenApply(result -> Response.forPayload((Object)JsonSerializerMiddlewares.serialize(objectWriter, result)).withHeader(CONTENT_TYPE, JSON));
    }

    public static <T> Middleware<AsyncHandler<Response<T>>, AsyncHandler<Response<ByteString>>> jsonSerializeResponse(ObjectWriter objectWriter) {
        return handler -> requestContext -> handler.invoke(requestContext).thenApply(response -> response.withPayload((Object)JsonSerializerMiddlewares.serialize(objectWriter, response.payload().orElse(null))).withHeader(CONTENT_TYPE, JSON));
    }

    public static <T> Middleware<SyncHandler<T>, AsyncHandler<Response<ByteString>>> jsonSerializeSync(ObjectWriter objectWriter) {
        Middleware syncToAsync = Middleware::syncToAsync;
        return syncToAsync.and(JsonSerializerMiddlewares.jsonSerialize(objectWriter));
    }

    public static <T> Middleware<SyncHandler<Response<T>>, AsyncHandler<Response<ByteString>>> jsonSerializeResponseSync(ObjectWriter objectWriter) {
        Middleware syncToAsync = Middleware::syncToAsync;
        return syncToAsync.and(JsonSerializerMiddlewares.jsonSerializeResponse(objectWriter));
    }
}

