/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.route;

import com.google.common.base.Preconditions;
import com.spotify.apollo.route.AutoValue_VersionedRouteImpl;
import com.spotify.apollo.route.VersionedRoute;
import java.util.Optional;

abstract class VersionedRouteImpl
implements VersionedRoute {
    VersionedRouteImpl() {
    }

    @Override
    public VersionedRoute validFrom(int validFrom) {
        Preconditions.checkArgument((validFrom >= 0 ? 1 : 0) != 0, (String)"validFrom must be non-negative, got %s", (Object[])new Object[]{validFrom});
        this.verifyRangeNonEmpty(validFrom, this.removedIn());
        return new AutoValue_VersionedRouteImpl(this.route(), validFrom, this.removedIn());
    }

    @Override
    public VersionedRoute removedIn(int removedIn) {
        Preconditions.checkArgument((removedIn >= 0 ? 1 : 0) != 0, (String)"removedIn must be non-negative, got %s", (Object[])new Object[]{removedIn});
        this.verifyRangeNonEmpty(this.validFrom(), Optional.of(removedIn));
        return new AutoValue_VersionedRouteImpl(this.route(), this.validFrom(), Optional.of(removedIn));
    }

    private void verifyRangeNonEmpty(int validFrom, Optional<Integer> removedIn) {
        int effectiveRemovedIn = removedIn.orElse(validFrom + 1);
        Preconditions.checkArgument((validFrom < effectiveRemovedIn ? 1 : 0) != 0, (String)"empty version range: [%s, %s)", (Object[])new Object[]{validFrom, effectiveRemovedIn});
    }
}

