/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.route;

import com.google.common.annotations.VisibleForTesting;
import com.spotify.apollo.Response;
import com.spotify.apollo.route.AsyncHandler;
import com.spotify.apollo.route.Route;
import com.spotify.apollo.route.VersionedRoute;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import okio.ByteString;

public class Versions {
    private final int startVersion;
    private final int lastVersion;

    public Versions(int startVersion, int lastVersion) {
        this.startVersion = startVersion;
        this.lastVersion = lastVersion;
    }

    public Stream<Route<AsyncHandler<Response<ByteString>>>> expand(Stream<VersionedRoute> versionedRouteStream) {
        List<Route<AsyncHandler<Response<ByteString>>>> routes = this.expandToRoutes(versionedRouteStream);
        this.sanityCheck(routes);
        return routes.stream();
    }

    private List<Route<AsyncHandler<Response<ByteString>>>> expandToRoutes(Stream<VersionedRoute> versionedRouteStream) {
        return versionedRouteStream.flatMap(versionedRoute -> {
            int lowerBound = Math.max(this.startVersion, versionedRoute.validFrom());
            int upperBoundExclusive = versionedRoute.removedIn().orElse(this.lastVersion + 1);
            Route<AsyncHandler<Response<ByteString>>> route = versionedRoute.route();
            return IntStream.range(lowerBound, upperBoundExclusive).mapToObj(i -> route.copy(route.method(), "/v" + String.valueOf(i) + (route.uri().startsWith("/") ? "" : "/") + route.uri(), route.handler(), (Route.DocString)route.docString().orElse(null)));
        }).collect(Collectors.toList());
    }

    @VisibleForTesting
    static String methodUri(Route<?> route) {
        return route.method() + " " + route.uri();
    }

    private void sanityCheck(List<Route<AsyncHandler<Response<ByteString>>>> routes) {
        Map<String, Long> methodUriCounts = routes.stream().collect(Collectors.groupingBy(Versions::methodUri, Collectors.counting()));
        Set overlappingMethodUris = methodUriCounts.entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (!overlappingMethodUris.isEmpty()) {
            throw new IllegalArgumentException("versioned routes overlap for the following method/uris: " + overlappingMethodUris);
        }
    }

    public static NeedsTo from(int startVersionInclusive) {
        return new NeedsTo(startVersionInclusive);
    }

    public static class NeedsTo {
        private final int startVersion;

        public NeedsTo(int startVersion) {
            this.startVersion = startVersion;
        }

        public Versions to(int lastVersionInclusive) {
            return new Versions(this.startVersion, lastVersionInclusive);
        }
    }
}

