/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.httpservice;

import com.spotify.apollo.AppInit;
import com.spotify.apollo.core.Service;
import com.spotify.apollo.core.Services;
import com.spotify.apollo.environment.ApolloConfig;
import com.spotify.apollo.http.client.HttpClientModule;
import com.spotify.apollo.http.server.HttpServerModule;
import com.spotify.apollo.httpservice.HttpServiceModule;
import com.spotify.apollo.httpservice.InstanceListener;
import com.spotify.apollo.httpservice.LoadingException;
import com.spotify.apollo.httpservice.LogAndExit;
import com.spotify.apollo.meta.MetaDescriptor;
import com.spotify.apollo.module.ApolloModule;
import com.spotify.apollo.request.RequestHandler;
import java.io.IOException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpService {
    private static final Logger LOG = LoggerFactory.getLogger(HttpService.class);

    private HttpService() {
    }

    public static Service.Builder usingAppInit(AppInit appInit, String serviceName) {
        return HttpService.builder(serviceName).withModule((ApolloModule)HttpServiceModule.create(appInit));
    }

    public static Service.Builder builder(String serviceName) {
        return Services.usingName((String)serviceName).usingModuleDiscovery(false).withModule(HttpClientModule.create()).withModule((ApolloModule)HttpServerModule.create());
    }

    public static void boot(AppInit appInit, String serviceName, String ... args) throws LoadingException {
        HttpService.boot(appInit, serviceName, HttpService.noopListener(), args);
    }

    public static void boot(AppInit appInit, String serviceName, InstanceListener instanceListener, String ... args) throws LoadingException {
        Service service = HttpService.usingAppInit(appInit, serviceName).build();
        HttpService.boot(service, instanceListener, args);
    }

    public static void boot(Service service, String ... args) throws LoadingException {
        HttpService.boot(service, HttpService.noopListener(), args);
    }

    public static void boot(Service service, InstanceListener instanceListener, String ... args) throws LoadingException {
        HttpService.boot(service, instanceListener, new LogAndExit(), args);
    }

    public static void boot(Service service, InstanceListener instanceListener, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, String ... args) throws LoadingException {
        Objects.requireNonNull(uncaughtExceptionHandler);
        Thread.currentThread().setUncaughtExceptionHandler(uncaughtExceptionHandler);
        LOG.debug("Trying to create instance of service {} with args {}", (Object)service.getServiceName(), (Object)args);
        try (Service.Instance instance = service.start(args);){
            RequestHandler requestHandler = HttpServiceModule.requestHandler(instance);
            HttpServerModule.server((Service.Instance)instance).start(requestHandler);
            String serviceName = service.getServiceName();
            MetaDescriptor metaDescriptor = (MetaDescriptor)instance.resolve(MetaDescriptor.class);
            ApolloConfig config = (ApolloConfig)instance.resolve(ApolloConfig.class);
            LOG.info("Started {} {} (apollo {}) with backend domain '{}'", new Object[]{serviceName, metaDescriptor.descriptor().version(), metaDescriptor.apolloVersion(), config.backend()});
            if (instanceListener != null) {
                instanceListener.instanceCreated(instance);
            }
            instance.waitForShutdown();
            LOG.info("Starting shutdown of {} ...", (Object)serviceName);
        }
        catch (IOException e) {
            throw HttpService.failure(e, "Failed to start service", new Object[0]);
        }
        catch (InterruptedException e) {
            throw HttpService.failure(e, "Service interrupted", new Object[0]);
        }
        catch (Exception e) {
            throw HttpService.failure(e, "Something went wrong", new Object[0]);
        }
        LOG.info("Shutdown of {} complete", (Object)service.getServiceName());
    }

    static LoadingException failure(Throwable cause, String message, Object ... args) {
        return new LoadingException(String.format(message, args), cause);
    }

    static InstanceListener noopListener() {
        return instance -> {};
    }
}

