/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.httpservice;

import com.google.inject.Module;
import com.spotify.apollo.AppInit;
import com.spotify.apollo.core.Service;
import com.spotify.apollo.environment.ApolloEnvironment;
import com.spotify.apollo.environment.ApolloEnvironmentModule;
import com.spotify.apollo.module.AbstractApolloModule;
import com.spotify.apollo.request.RequestHandler;

class HttpServiceModule
extends AbstractApolloModule {
    private final AppInit appInit;

    private HttpServiceModule(AppInit appInit) {
        this.appInit = appInit;
    }

    public static HttpServiceModule create(AppInit appInit) {
        return new HttpServiceModule(appInit);
    }

    protected void configure() {
        this.bindAppInit();
        this.install((Module)ApolloEnvironmentModule.create());
    }

    private void bindAppInit() {
        this.bind(Initializer.class).toInstance(env -> env.initialize(this.appInit));
    }

    static RequestHandler requestHandler(Service.Instance instance) {
        ApolloEnvironment environment = ApolloEnvironmentModule.environment((Service.Instance)instance);
        Initializer initializer = (Initializer)instance.resolve(Initializer.class);
        return initializer.init(environment);
    }

    public String getId() {
        return "apollo-http-service";
    }

    private static interface Initializer {
        public RequestHandler init(ApolloEnvironment var1);
    }
}

