/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.http.server;

import com.google.common.collect.ImmutableMap;
import com.spotify.apollo.Request;
import com.spotify.apollo.Response;
import com.spotify.apollo.StatusType;
import com.spotify.apollo.http.server.HttpRequest;
import com.spotify.apollo.request.OngoingRequest;
import com.spotify.apollo.request.RequestHandler;
import com.spotify.apollo.request.ServerInfo;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import okio.ByteString;
import org.eclipse.jetty.server.handler.AbstractHandler;

class ApolloRequestHandler
extends AbstractHandler {
    private final RequestHandler requestHandler;
    private final ServerInfo serverInfo;

    ApolloRequestHandler(ServerInfo serverInfo, RequestHandler requestHandler) {
        this.requestHandler = Objects.requireNonNull(requestHandler);
        this.serverInfo = Objects.requireNonNull(serverInfo);
    }

    public void handle(String target, org.eclipse.jetty.server.Request baseRequest, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        String uri = req.getRequestURI();
        String method = req.getMethod();
        int contentLength = req.getContentLength();
        Optional<ByteString> payload = contentLength > -1 ? Optional.of(this.readPayload(req, contentLength)) : Optional.empty();
        ImmutableMap.Builder headersBuilder = ImmutableMap.builder();
        ApolloRequestHandler.toStream(req.getHeaderNames()).forEachOrdered(name -> headersBuilder.put(name, (Object)ApolloRequestHandler.toStream(req.getHeaders(name)).collect(Collectors.joining(","))));
        ImmutableMap.Builder parametersBuilder = ImmutableMap.builder();
        req.getParameterMap().entrySet().stream().forEachOrdered(parameter -> parametersBuilder.put(parameter.getKey(), Arrays.asList((Object[])parameter.getValue())));
        ImmutableMap headers = headersBuilder.build();
        ImmutableMap parameters = parametersBuilder.build();
        Request request = HttpRequest.create(method, uri, payload, Optional.empty(), (Map<String, List<String>>)parameters, (Map<String, String>)headers);
        AsyncContext asyncContext = baseRequest.startAsync();
        this.requestHandler.handle((OngoingRequest)new AsyncContextOngoingRequest(this.serverInfo, request, asyncContext));
        baseRequest.setHandled(true);
    }

    private ByteString readPayload(HttpServletRequest req, int contentLength) throws IOException {
        BufferedInputStream input = new BufferedInputStream((InputStream)req.getInputStream());
        return ByteString.read((InputStream)input, (int)contentLength);
    }

    static <T> Stream<T> toStream(Enumeration<T> enumeration) {
        ArrayList<T> list = new ArrayList<T>();
        while (enumeration.hasMoreElements()) {
            list.add(enumeration.nextElement());
        }
        return list.stream();
    }

    static class AsyncContextOngoingRequest
    implements OngoingRequest {
        private final ServerInfo serverInfo;
        private final Request request;
        private final AsyncContext asyncContext;

        AsyncContextOngoingRequest(ServerInfo serverInfo, Request request, AsyncContext asyncContext) {
            this.serverInfo = serverInfo;
            this.request = Objects.requireNonNull(request);
            this.asyncContext = Objects.requireNonNull(asyncContext);
        }

        public Request request() {
            return this.request;
        }

        public ServerInfo serverInfo() {
            return this.serverInfo;
        }

        public void reply(Response<ByteString> response) {
            HttpServletResponse httpResponse = (HttpServletResponse)this.asyncContext.getResponse();
            StatusType status = response.status();
            httpResponse.setStatus(status.code(), status.reasonPhrase());
            response.headers().forEach((arg_0, arg_1) -> ((HttpServletResponse)httpResponse).addHeader(arg_0, arg_1));
            try {
                Optional payload = response.payload();
                if (payload.isPresent()) {
                    ((ByteString)payload.get()).write((OutputStream)httpResponse.getOutputStream());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.asyncContext.complete();
        }

        public void drop() {
            this.asyncContext.complete();
        }

        public boolean isExpired() {
            return false;
        }
    }
}

