/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.http.server;

import com.google.common.collect.ImmutableMap;
import com.spotify.apollo.Request;
import com.spotify.apollo.http.server.AutoValue_HttpRequest;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import okio.ByteString;

abstract class HttpRequest
implements Request {
    HttpRequest() {
    }

    public Request withService(String service) {
        return HttpRequest.create(this.method(), this.uri(), this.payload(), Optional.of(service), this.parameters(), this.headers());
    }

    public Request withHeader(String name, String value) {
        ImmutableMap.Builder headers = ImmutableMap.builder();
        headers.putAll(this.headers());
        headers.put((Object)name, (Object)value);
        return HttpRequest.create(this.method(), this.uri(), this.payload(), this.service(), this.parameters(), (Map<String, String>)headers.build());
    }

    public Request withPayload(ByteString payload) {
        return HttpRequest.create(this.method(), this.uri(), Optional.of(payload), this.service(), this.parameters(), this.headers());
    }

    public static Request create(String method, String uri, Optional<ByteString> payload, Optional<String> service, Map<String, List<String>> parameters, Map<String, String> headers) {
        return new AutoValue_HttpRequest(method, uri, parameters, headers, service, payload);
    }
}

