/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.http.server;

import com.spotify.apollo.environment.ConfigUtil;
import com.typesafe.config.Config;
import javax.inject.Inject;
import javax.inject.Named;

class HttpServerConfig {
    private static final String CONFIG_BASE_NAME = "http.server";
    private static final String DEFAULT_HTTP_ADDRESS = "0.0.0.0";
    private static final int DEFAULT_TTL_MILLIS = 30000;
    private static final int DEFAULT_WORKER_THREADS = Math.max(Runtime.getRuntime().availableProcessors() / 4, 2);
    private static final int DEFAULT_KEEP_ALIVE_TIMEOUT = 300;
    private static final int DEFAULT_MAX_HTTP_CHUNK_LENGTH = 131072;
    private final String serviceName;
    private final Config config;

    @Inject
    HttpServerConfig(@Named(value="service-name") String serviceName, Config config) {
        this.serviceName = serviceName;
        this.config = config;
    }

    public String address() {
        return ConfigUtil.optionalString((Config)this.config, (String)"http.server.address").orElse(DEFAULT_HTTP_ADDRESS);
    }

    public Integer port() {
        return ConfigUtil.optionalInt((Config)this.config, (String)"http.server.port").orElse(null);
    }

    public String registrationName() {
        return ConfigUtil.optionalString((Config)this.config, (String)"http.server.registrationName").orElse(this.serviceName);
    }

    public long ttlMillis() {
        return ConfigUtil.optionalInt((Config)this.config, (String)"http.server.ttlMillis").orElse(30000).intValue();
    }

    public int keepAliveTimeout() {
        return ConfigUtil.optionalInt((Config)this.config, (String)"http.server.keepAliveTimeout").orElse(300);
    }

    public int workerThreads() {
        return ConfigUtil.optionalInt((Config)this.config, (String)"http.server.workerThreads").orElse(DEFAULT_WORKER_THREADS);
    }

    public int maxHttpChunkLength() {
        return ConfigUtil.optionalInt((Config)this.config, (String)"http.server.maxHttpChunkLength").orElse(131072);
    }

    public boolean useFirstPathSegmentAsAuthority() {
        return ConfigUtil.optionalBoolean((Config)this.config, (String)"http.server.useFirstPathSegmentAsAuthority").orElse(false);
    }
}

